/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.stats;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.rest.stats.ThrownStats;

public class ThrownStore {
    public static final ThrownStore GLOBAL = new ThrownStore();
    private final ConcurrentHashMap<Long, ThrownStats> db = new ConcurrentHashMap();
    private final Optional<ThrownStore> parent;
    private final BeanStore beanStore;
    private final Class<? extends ThrownStats> statsImplClass;
    private final Set<String> ignoreClasses;

    public static Builder create() {
        return new Builder(BeanStore.INSTANCE);
    }

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    public ThrownStore() {
        this(ThrownStore.create(BeanStore.INSTANCE));
    }

    public ThrownStore(Builder builder) {
        this.parent = Utils.opt(builder.parent);
        this.beanStore = builder.beanStore();
        this.statsImplClass = Utils.firstNonNull(builder.statsImplClass, this.parent.isPresent() ? this.parent.get().statsImplClass : null, null);
        Set<Object> s = null;
        if (Utils.nn(builder.ignoreClasses)) {
            s = builder.ignoreClasses.stream().map(Class::getName).collect(Collectors.toSet());
        }
        if (s == null && this.parent.isPresent()) {
            s = this.parent.get().ignoreClasses;
        }
        if (s == null) {
            s = Collections.emptySet();
        }
        this.ignoreClasses = CollectionUtils.u(s);
    }

    public ThrownStats add(Throwable e) {
        ThrownStats s = this.find(e);
        s.increment();
        this.parent.ifPresent(x -> x.add(e));
        return s;
    }

    public List<ThrownStats> getStats() {
        return this.db.values().stream().map(ThrownStats::clone).sorted(Comparator.comparingInt(ThrownStats::getCount).reversed()).collect(Collectors.toList());
    }

    public Optional<ThrownStats> getStats(long hash) {
        ThrownStats s = this.db.get(hash);
        return Utils.opt(s == null ? null : s.clone());
    }

    public Optional<ThrownStats> getStats(Throwable e) {
        return this.getStats(this.hash(e));
    }

    public void reset() {
        this.db.clear();
    }

    private ThrownStats find(Throwable t) {
        if (t == null) {
            return null;
        }
        long hash = this.hash(t);
        ThrownStats stc = this.db.get(hash);
        if (stc == null) {
            stc = ThrownStats.create(this.beanStore).type(this.statsImplClass).throwable(t).hash(hash).stackTrace(this.createStackTrace(t)).causedBy(this.find(t.getCause())).build();
            this.db.putIfAbsent(hash, stc);
            stc = this.db.get(hash);
        }
        return stc;
    }

    protected List<String> createStackTrace(Throwable t) {
        return CollectionUtils.l(t.getStackTrace()).stream().filter(this::include).map(this::normalize).collect(Collectors.toList());
    }

    protected long hash(Throwable t) {
        long h = 1125899906842597L;
        for (String s : this.createStackTrace(t)) {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                h = 31L * h + (long)s.charAt(i);
            }
        }
        return h;
    }

    protected boolean include(StackTraceElement e) {
        return true;
    }

    protected String normalize(StackTraceElement e) {
        if (this.ignoreClasses.contains(e.getClassName())) {
            return "<ignored>";
        }
        String s = e.toString();
        int i = s.indexOf(36);
        if (i == -1) {
            return s;
        }
        int j = s.indexOf(40, i);
        if (j == -1) {
            return s;
        }
        String s2 = s.substring(0, i);
        String s3 = s.substring(j);
        if (this.ignoreClasses.contains(s2)) {
            return "<ignored>";
        }
        return s2 + "..." + s3;
    }

    public static class Builder
    extends BeanBuilder<ThrownStore> {
        ThrownStore parent;
        Class<? extends ThrownStats> statsImplClass;
        Set<Class<?>> ignoreClasses;

        protected Builder(BeanStore beanStore) {
            super(ThrownStore.class, beanStore);
        }

        public Builder ignoreClasses(Class<?> ... value) {
            this.ignoreClasses = CollectionUtils.set(value);
            return this;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder parent(ThrownStore value) {
            this.parent = value;
            return this;
        }

        public Builder statsImplClass(Class<? extends ThrownStats> value) {
            this.statsImplClass = value;
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        @Override
        protected ThrownStore buildDefault() {
            return new ThrownStore(this);
        }
    }
}

