/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.Transient;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanFilter;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanProxyInvocationHandler;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.Beanc;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.annotation.Name;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.function.OptionalSupplier;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.BeanRuntimeException;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.reflect.FieldInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.reflect.TypeVariables;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class BeanMeta<T> {
    private final BeanConstructor beanConstructor;
    private final BeanContext beanContext;
    private final BeanFilter beanFilter;
    private final OptionalSupplier<InvocationHandler> beanProxyInvocationHandler;
    private final Supplier<BeanRegistry> beanRegistry;
    private final Supplier<List<ClassInfo>> classHierarchy;
    private final ClassMeta<T> classMeta;
    private final Supplier<String> dictionaryName;
    private final BeanPropertyMeta dynaProperty;
    private final boolean fluentSetters;
    private final Map<Method, String> getterProps;
    private final Map<String, BeanPropertyMeta> hiddenProperties;
    private final ConstructorInfo implClassConstructor;
    private final String notABeanReason;
    private final Map<String, BeanPropertyMeta> properties;
    private final Map<Method, String> setterProps;
    private final boolean sortProperties;
    private final ClassInfo stopClass;
    private final BeanPropertyMeta typeProperty;
    private final String typePropertyName;

    public static <T> BeanMetaValue<T> create(ClassMeta<T> cm, ClassInfo implClass) {
        try {
            BeanContext bc = cm.getBeanContext();
            AnnotationProvider ap = bc.getAnnotationProvider();
            if (bc.isNotABean((ClassInfo)cm)) {
                return BeanMeta.notABean("Class matches exclude-class list");
            }
            if (bc.isBeansRequireSerializable() && !cm.isChildOf(Serializable.class) && !ap.has(Bean.class, cm, new AnnotationTraversal[0])) {
                return BeanMeta.notABean("Class is not serializable");
            }
            if (ap.has(BeanIgnore.class, cm, new AnnotationTraversal[0])) {
                return BeanMeta.notABean("Class is annotated with @BeanIgnore");
            }
            if (!(bc.getBeanClassVisibility().isVisible(cm.getModifiers()) && !cm.isAnonymousClass() || ap.has(Bean.class, cm, new AnnotationTraversal[0]))) {
                return BeanMeta.notABean("Class is not public");
            }
            BeanMeta<T> bm = new BeanMeta<T>(cm, BeanMeta.findBeanFilter(cm), null, implClass);
            if (Utils.nn((Object)bm.notABeanReason)) {
                return BeanMeta.notABean(bm.notABeanReason);
            }
            return new BeanMetaValue<T>(bm, null);
        }
        catch (RuntimeException e) {
            return new BeanMetaValue(null, e.getMessage());
        }
    }

    private static String bpName(List<Beanp> p, List<Name> n) {
        if (p.isEmpty() && n.isEmpty()) {
            return null;
        }
        if (!n.isEmpty()) {
            return ((Name)CollectionUtils.last(n)).value();
        }
        Value name = Value.of((Object)(p.isEmpty() ? null : ""));
        p.forEach(x -> {
            if (!x.value().isEmpty()) {
                name.set((Object)x.value());
            }
            if (!x.name().isEmpty()) {
                name.set((Object)x.name());
            }
        });
        return (String)name.orElse(null);
    }

    private static <T> BeanFilter findBeanFilter(ClassMeta<T> cm) {
        AnnotationProvider ap = cm.getBeanContext().getAnnotationProvider();
        List l = ap.find(Bean.class, cm, new AnnotationTraversal[0]);
        if (l.isEmpty()) {
            return null;
        }
        return BeanFilter.create(cm).applyAnnotations(CollectionUtils.reverse(l.stream().map(AnnotationInfo::inner).toList())).build();
    }

    private static String name(AnnotationInfo<?> ai) {
        if (ai.isType(Beanp.class)) {
            Beanp p = (Beanp)ai.cast(Beanp.class).inner();
            if (Utils.ne((CharSequence)p.name())) {
                return p.name();
            }
            if (Utils.ne((CharSequence)p.value())) {
                return p.value();
            }
        } else {
            Name n = (Name)ai.cast(Name.class).inner();
            if (Utils.ne((CharSequence)n.value())) {
                return n.value();
            }
        }
        return null;
    }

    private static <T> BeanMetaValue<T> notABean(String reason) {
        return new BeanMetaValue(null, reason);
    }

    protected BeanMeta(ClassMeta<T> cm, BeanFilter bf, String[] pNames, ClassInfo implClass) {
        this.classMeta = cm;
        this.beanContext = cm.getBeanContext();
        this.beanFilter = bf;
        this.implClassConstructor = Utils.opt((Object)implClass).map(x -> x.getPublicConstructor(x2 -> x2.hasNumParameters(0)).orElse(null)).orElse(null);
        this.fluentSetters = this.beanContext.isFindFluentSetters() || Utils.nn((Object)bf) && bf.isFluentSetters();
        this.stopClass = Utils.opt((Object)bf).map(x -> x.getStopClass()).orElse((ClassInfo)ReflectionUtils.info(Object.class));
        this.beanRegistry = Utils.mem(() -> this.findBeanRegistry());
        this.classHierarchy = Utils.mem(() -> this.findClassHierarchy());
        this.beanConstructor = this.findBeanConstructor();
        AnnotationProvider ap = this.beanContext.getAnnotationProvider();
        Class c = cm.inner();
        ClassMeta ci = cm;
        Object _notABeanReason = null;
        Value _properties = Value.empty();
        LinkedHashMap _hiddenProperties = CollectionUtils.map();
        LinkedHashMap _getterProps = CollectionUtils.map();
        LinkedHashMap _setterProps = CollectionUtils.map();
        Value _dynaProperty = Value.empty();
        boolean _sortProperties = false;
        List ba = ap.find(Bean.class, cm, new AnnotationTraversal[0]);
        PropertyNamer propertyNamer = Utils.opt((Object)bf).map(x -> x.getPropertyNamer()).orElse(this.beanContext.getPropertyNamer());
        this.typePropertyName = ba.stream().map(x -> ((Bean)x.inner()).typePropertyName()).filter(Utils::ne).findFirst().orElseGet(() -> this.beanContext.getBeanTypePropertyName());
        if (!this.beanConstructor.constructor().isPresent() && bf == null && this.beanContext.isBeansRequireDefaultConstructor()) {
            _notABeanReason = "Class does not have the required no-arg constructor";
        }
        Optional bfo = Utils.opt((Object)bf);
        Set fixedBeanProps = bfo.map(x -> x.getProperties()).orElse(CollectionUtils.sete());
        try {
            LinkedHashMap normalProps = CollectionUtils.map();
            fixedBeanProps.forEach(x -> normalProps.put(x, BeanPropertyMeta.builder(this, x)));
            if (this.beanContext.isUseJavaBeanIntrospector()) {
                ClassInfo c2 = (ClassInfo)bfo.map(x -> x.getInterfaceClass()).filter(Objects::nonNull).orElse((ClassInfo)this.classMeta);
                BeanInfo bi = null;
                bi = !c2.isInterface() ? Introspector.getBeanInfo(c2.inner(), this.stopClass.inner()) : Introspector.getBeanInfo(c2.inner(), null);
                if (Utils.nn((Object)bi)) {
                    for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                        BeanPropertyMeta.Builder builder = normalProps.computeIfAbsent(pd.getName(), n -> BeanPropertyMeta.builder(this, n));
                        if (pd.getReadMethod() != null) {
                            builder.setGetter(ReflectionUtils.info((Method)pd.getReadMethod()));
                        }
                        if (pd.getWriteMethod() == null) continue;
                        builder.setSetter(ReflectionUtils.info((Method)pd.getWriteMethod()));
                    }
                }
            } else {
                this.findBeanFields().forEach(x -> {
                    String name = ap.find(x, new AnnotationTraversal[0]).stream().filter(x2 -> x2.isType(Beanp.class) || x2.isType(Name.class)).map(x2 -> BeanMeta.name(x2)).filter(Objects::nonNull).findFirst().orElse(propertyNamer.getPropertyName(x.getName()));
                    if (Utils.nn((Object)name)) {
                        normalProps.computeIfAbsent(name, n -> BeanPropertyMeta.builder(this, n)).setField((FieldInfo)x);
                    }
                });
                List<BeanMethod> bms = this.findBeanMethods();
                bms.forEach(x -> {
                    String pn = x.propertyName;
                    Method m = x.method;
                    MethodInfo mi = ReflectionUtils.info((Method)m);
                    BeanPropertyMeta.Builder bpm = normalProps.computeIfAbsent(pn, k -> new BeanPropertyMeta.Builder(this, (String)k));
                    if (x.methodType == MethodType.GETTER) {
                        if (Utils.nn((Object)bpm.getter)) {
                            if (!ap.has(Beanp.class, mi, new AnnotationTraversal[0]) && ap.has(Beanp.class, bpm.getter, new AnnotationTraversal[0])) {
                                m = bpm.getter.inner();
                            } else if (m.getName().startsWith("is") && bpm.getter.getSimpleName().startsWith("get")) {
                                m = bpm.getter.inner();
                            }
                        }
                        bpm.setGetter(ReflectionUtils.info((Method)m));
                    }
                });
                bms.stream().filter(x -> Utils.eq((Object)((Object)x.methodType), (Object)((Object)MethodType.SETTER))).forEach(x -> {
                    BeanPropertyMeta.Builder bpm = (BeanPropertyMeta.Builder)normalProps.get(x.propertyName);
                    if (x.matchesPropertyType(bpm)) {
                        bpm.setSetter(ReflectionUtils.info((Method)x.method));
                    }
                });
                bms.stream().filter(x -> Utils.eq((Object)((Object)x.methodType), (Object)((Object)MethodType.EXTRAKEYS))).forEach(x -> ((BeanPropertyMeta.Builder)normalProps.get(x.propertyName)).setExtraKeys(ReflectionUtils.info((Method)x.method)));
            }
            TypeVariables typeVarImpls = TypeVariables.of((Type)c);
            Set readOnlyProps = bfo.map(x -> x.getReadOnlyProperties()).orElse(CollectionUtils.sete());
            Set writeOnlyProps = bfo.map(x -> x.getWriteOnlyProperties()).orElse(CollectionUtils.sete());
            Iterator<Object> i = normalProps.values().iterator();
            while (i.hasNext()) {
                BeanPropertyMeta.Builder p = (BeanPropertyMeta.Builder)i.next();
                try {
                    if (p.field == null) {
                        this.findInnerBeanField(p.name).ifPresent(x -> p.setInnerField((FieldInfo)x));
                    }
                    if (p.validate(this.beanContext, this.beanRegistry.get(), typeVarImpls, readOnlyProps, writeOnlyProps)) {
                        if (Utils.nn((Object)p.getter)) {
                            _getterProps.put(p.getter.inner(), p.name);
                        }
                        if (!Utils.nn((Object)p.setter)) continue;
                        _setterProps.put(p.setter.inner(), p.name);
                        continue;
                    }
                    i.remove();
                }
                catch (ClassNotFoundException e) {
                    throw ThrowableUtils.bex((Class)c, (String)ThrowableUtils.lm((Throwable)e), (Object[])new Object[0]);
                }
            }
            fixedBeanProps.stream().filter(x -> !normalProps.containsKey(x)).findFirst().ifPresent(x -> {
                throw ThrowableUtils.bex((Class)c, (String)"The property ''{0}'' was defined on the @Bean(properties=X) annotation of class ''{1}'' but was not found on the class definition.", (Object[])new Object[]{x, ci.getNameSimple()});
            });
            for (String fp : this.beanConstructor.args()) {
                BeanPropertyMeta.Builder m = (BeanPropertyMeta.Builder)normalProps.get(fp);
                if (m == null) {
                    throw ThrowableUtils.bex((Class)c, (String)"The property ''{0}'' was defined on the @Beanc(properties=X) annotation but was not found on the class definition.", (Object[])new Object[]{fp});
                }
                m.setAsConstructorArg();
            }
            if (bf == null && this.beanContext.isBeansRequireSomeProperties() && normalProps.isEmpty()) {
                _notABeanReason = "No properties detected on bean class";
            }
            _sortProperties = this.beanContext.isSortProperties() || bfo.map(x -> x.isSortProperties()).orElse(false) != false && fixedBeanProps.isEmpty();
            _properties.set((Object)(_sortProperties ? CollectionUtils.sortedMap() : CollectionUtils.map()));
            normalProps.forEach((k, v) -> {
                BeanPropertyMeta pMeta = v.build();
                if (pMeta.isDyna()) {
                    _dynaProperty.set((Object)pMeta);
                }
                ((Map)_properties.get()).put(k, pMeta);
            });
            if (bf != null) {
                Set<String> bfbpi = bf.getProperties();
                Set<String> bfbpx = bf.getExcludeProperties();
                Map p = (Map)_properties.get();
                if (!bfbpi.isEmpty()) {
                    LinkedHashMap p2 = CollectionUtils.map();
                    bfbpi.stream().filter(x -> p.containsKey(x)).forEach(x -> p2.put(x, (BeanPropertyMeta)p.remove(x)));
                    _hiddenProperties.putAll(p);
                    _properties.set((Object)p2);
                }
                bfbpx.forEach(x -> _hiddenProperties.put(x, (BeanPropertyMeta)((Map)_properties.get()).remove(x)));
            }
            if (Utils.nn((Object)pNames)) {
                Map p = (Map)_properties.get();
                LinkedHashMap p2 = CollectionUtils.map();
                for (String k2 : pNames) {
                    if (p.containsKey(k2)) {
                        p2.put(k2, (BeanPropertyMeta)p.get(k2));
                        continue;
                    }
                    _hiddenProperties.put(k2, (BeanPropertyMeta)p.get(k2));
                }
                _properties.set((Object)p2);
            }
        }
        catch (BeanRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            _notABeanReason = "Exception:  " + ThrowableUtils.getStackTrace((Throwable)e);
        }
        this.notABeanReason = _notABeanReason;
        this.properties = CollectionUtils.u((Map)((Map)_properties.get()));
        this.hiddenProperties = CollectionUtils.u((Map)_hiddenProperties);
        this.getterProps = CollectionUtils.u((Map)_getterProps);
        this.setterProps = CollectionUtils.u((Map)_setterProps);
        this.dynaProperty = (BeanPropertyMeta)_dynaProperty.get();
        this.sortProperties = _sortProperties;
        this.typeProperty = BeanPropertyMeta.builder(this, this.typePropertyName).canRead().canWrite().rawMetaType(this.beanContext.string()).beanRegistry(this.beanRegistry.get()).build();
        this.dictionaryName = Utils.mem(() -> this.findDictionaryName());
        this.beanProxyInvocationHandler = Utils.mem(() -> this.beanContext.isUseInterfaceProxies() && c.isInterface() ? new BeanProxyInvocationHandler(this) : null);
    }

    public boolean equals(Object o) {
        BeanMeta o2;
        return o instanceof BeanMeta && Utils.eq((Object)this, (Object)(o2 = (BeanMeta)o), (x, y) -> Utils.eq(x.classMeta, y.classMeta));
    }

    public BeanFilter getBeanFilter() {
        return this.beanFilter;
    }

    public InvocationHandler getBeanProxyInvocationHandler() {
        return (InvocationHandler)this.beanProxyInvocationHandler.get();
    }

    public BeanRegistry getBeanRegistry() {
        return this.beanRegistry.get();
    }

    public ClassMeta<T> getClassMeta() {
        return this.classMeta;
    }

    public String getDictionaryName() {
        return this.dictionaryName.get();
    }

    public Map<String, BeanPropertyMeta> getProperties() {
        return this.properties;
    }

    public BeanPropertyMeta getPropertyMeta(String name) {
        BeanPropertyMeta bpm = this.properties.get(name);
        if (bpm == null) {
            bpm = this.hiddenProperties.get(name);
        }
        if (bpm == null) {
            bpm = this.dynaProperty;
        }
        return bpm;
    }

    public BeanPropertyMeta getTypeProperty() {
        return this.typeProperty;
    }

    public String getTypePropertyName() {
        return this.typePropertyName;
    }

    public int hashCode() {
        return this.classMeta.hashCode();
    }

    public Object onReadProperty(Object bean, String name, Object value) {
        return this.beanFilter == null ? value : this.beanFilter.readProperty(bean, name, value);
    }

    public Object onWriteProperty(Object bean, String name, Object value) {
        return this.beanFilter == null ? value : this.beanFilter.writeProperty(bean, name, value);
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.filteredBeanPropertyMap().a((Object)"class", (Object)this.classMeta.getName()).a((Object)"properties", this.properties);
    }

    public String toString() {
        return Utils.r(this.properties());
    }

    protected BeanContext getBeanContext() {
        return this.beanContext;
    }

    protected ConstructorInfo getConstructor() {
        return this.beanConstructor.constructor().orElse(null);
    }

    protected List<String> getConstructorArgs() {
        return this.beanConstructor.args();
    }

    protected BeanPropertyMeta getDynaProperty() {
        return this.dynaProperty;
    }

    protected Map<Method, String> getGetterProps() {
        return this.getterProps;
    }

    protected Map<String, BeanPropertyMeta> getHiddenProperties() {
        return this.hiddenProperties;
    }

    protected Map<Method, String> getSetterProps() {
        return this.setterProps;
    }

    protected boolean hasConstructor() {
        return this.beanConstructor.constructor().isPresent();
    }

    protected boolean isSortProperties() {
        return this.sortProperties;
    }

    protected T newBean(Object outer) throws ExecutableException {
        if (this.classMeta.isMemberClass() && this.classMeta.isNotStatic()) {
            if (this.hasConstructor()) {
                return (T)this.getConstructor().newInstance(new Object[]{outer});
            }
        } else {
            if (this.hasConstructor()) {
                return (T)this.getConstructor().newInstance(new Object[0]);
            }
            InvocationHandler h = this.classMeta.getProxyInvocationHandler();
            if (Utils.nn((Object)h)) {
                ClassLoader cl = this.classMeta.getClassLoader();
                return (T)Proxy.newProxyInstance(cl, (Class[])CollectionUtils.a((Object[])new Class[]{this.classMeta.inner(), Serializable.class}), h);
            }
        }
        return null;
    }

    private BeanConstructor findBeanConstructor() {
        AnnotationProvider ap = this.beanContext.getAnnotationProvider();
        Visibility vis = this.beanContext.getBeanConstructorVisibility();
        ClassMeta<T> ci = this.classMeta;
        List<ConstructorInfo> l = ci.getPublicConstructors().stream().filter(x -> ap.has(Beanc.class, x, new AnnotationTraversal[0])).toList();
        if (l.isEmpty()) {
            l = ci.getDeclaredConstructors().stream().filter(x -> ap.has(Beanc.class, x, new AnnotationTraversal[0])).toList();
        }
        if (l.size() > 1) {
            throw ThrowableUtils.bex(ci, (String)"Multiple instances of '@Beanc' found.", (Object[])new Object[0]);
        }
        if (l.size() == 1) {
            List<String> args;
            ConstructorInfo con = l.get(0).accessible();
            if (!con.hasNumParameters((args = ap.find(Beanc.class, con, new AnnotationTraversal[0]).stream().map(x -> ((Beanc)x.inner()).properties()).filter(StringUtils::isNotBlank).map(x -> StringUtils.split((String)x)).findFirst().orElse(CollectionUtils.liste())).size())) {
                if (Utils.ne((Collection)args)) {
                    throw ThrowableUtils.bex(ci, (String)"Number of properties defined in '@Beanc' annotation does not match number of parameters in constructor.", (Object[])new Object[0]);
                }
                args = con.getParameters().stream().map(x -> x.getName()).toList();
                for (int i = 0; i < args.size(); ++i) {
                    if (!StringUtils.isBlank((CharSequence)args.get(i))) continue;
                    throw ThrowableUtils.bex(ci, (String)"Could not find name for parameter #{0} of constructor ''{1}''", (Object[])new Object[]{i, con.getFullName()});
                }
            }
            return new BeanConstructor(Utils.opt((Object)con), args);
        }
        if (this.implClassConstructor != null) {
            return new BeanConstructor(Utils.opt((Object)this.implClassConstructor.accessible()), CollectionUtils.liste());
        }
        List ba = ap.find(Bean.class, this.classMeta, new AnnotationTraversal[0]);
        ConstructorInfo con = ci.getNoArgConstructor(!ba.isEmpty() ? Visibility.PRIVATE : vis).orElse(null);
        if (con != null) {
            return new BeanConstructor(Utils.opt((Object)con.accessible()), CollectionUtils.liste());
        }
        return new BeanConstructor(Utils.opte(), CollectionUtils.liste());
    }

    private Collection<FieldInfo> findBeanFields() {
        Visibility v = this.beanContext.getBeanFieldVisibility();
        boolean noIgnoreTransients = !this.beanContext.isIgnoreTransientFields();
        AnnotationProvider ap = this.beanContext.getAnnotationProvider();
        return this.classHierarchy.get().stream().flatMap(c2 -> c2.getDeclaredFields().stream()).filter(x -> !(!x.isNotStatic() || !x.isNotTransient() && !noIgnoreTransients || x.hasAnnotation(Transient.class) && !noIgnoreTransients || ap.has(BeanIgnore.class, x, new AnnotationTraversal[0]) || !v.isVisible(x.inner()) && !ap.has(Beanp.class, x, new AnnotationTraversal[0]))).toList();
    }

    private List<BeanMethod> findBeanMethods() {
        LinkedList<BeanMethod> l = new LinkedList<BeanMethod>();
        AnnotationProvider ap = this.beanContext.getAnnotationProvider();
        ClassMeta<T> ci = this.classMeta;
        Visibility v = this.beanContext.getBeanMethodVisibility();
        PropertyNamer pn = Utils.opt((Object)this.beanFilter).map(x -> x.getPropertyNamer()).orElse(this.beanContext.getPropertyNamer());
        this.classHierarchy.get().stream().forEach(c2 -> {
            for (MethodInfo m : c2.getDeclaredMethods()) {
                List mm;
                if (m.isStatic() || m.isBridge() || m.getParameterCount() > 2 || (mm = m.getMatchingMethods()).stream().anyMatch(m2 -> ap.has(BeanIgnore.class, m2, new AnnotationTraversal[]{AnnotationTraversal.SELF})) || mm.stream().anyMatch(m2 -> ap.find(Transient.class, m2, new AnnotationTraversal[]{AnnotationTraversal.SELF}).stream().map(x -> ((Transient)x.inner()).value()).findFirst().orElse(false))) continue;
                List<Beanp> beanps = ap.find(Beanp.class, m, new AnnotationTraversal[0]).stream().map(AnnotationInfo::inner).toList();
                List<Name> names = ap.find(Name.class, m, new AnnotationTraversal[0]).stream().map(AnnotationInfo::inner).toList();
                if (!m.isVisible(v) && !Utils.ne(beanps) && !Utils.ne(names)) continue;
                String n = m.getSimpleName();
                List params = m.getParameters();
                ClassInfo rt = m.getReturnType();
                MethodType methodType = MethodType.UNKNOWN;
                String bpName = BeanMeta.bpName(beanps, names);
                if (params.isEmpty()) {
                    if ("*".equals(bpName)) {
                        if (rt.isChildOf(Collection.class)) {
                            methodType = MethodType.EXTRAKEYS;
                        } else if (rt.isChildOf(Map.class)) {
                            methodType = MethodType.GETTER;
                        }
                        n = bpName;
                    } else if (n.startsWith("get") && !rt.is(Void.TYPE)) {
                        methodType = MethodType.GETTER;
                        n = n.substring(3);
                    } else if (n.startsWith("is") && (rt.is(Boolean.TYPE) || rt.is(Boolean.class))) {
                        methodType = MethodType.GETTER;
                        n = n.substring(2);
                    } else if (Utils.nn((Object)bpName)) {
                        methodType = MethodType.GETTER;
                        if (bpName.isEmpty()) {
                            if (n.startsWith("get")) {
                                n = n.substring(3);
                            } else if (n.startsWith("is")) {
                                n = n.substring(2);
                            }
                            bpName = n;
                        } else {
                            n = bpName;
                        }
                    }
                } else if (params.size() == 1) {
                    if ("*".equals(bpName)) {
                        if (((ParameterInfo)params.get(0)).getParameterType().isChildOf(Map.class)) {
                            methodType = MethodType.SETTER;
                            n = bpName;
                        } else if (((ParameterInfo)params.get(0)).getParameterType().is(String.class)) {
                            methodType = MethodType.GETTER;
                            n = bpName;
                        }
                    } else if (n.startsWith("set") && (rt.isParentOf((ClassInfo)ci) || rt.is(Void.TYPE))) {
                        methodType = MethodType.SETTER;
                        n = n.substring(3);
                    } else if (n.startsWith("with") && rt.isParentOf((ClassInfo)ci)) {
                        methodType = MethodType.SETTER;
                        n = n.substring(4);
                    } else if (Utils.nn((Object)bpName)) {
                        methodType = MethodType.SETTER;
                        if (bpName.isEmpty()) {
                            if (n.startsWith("set")) {
                                n = n.substring(3);
                            }
                            bpName = n;
                        } else {
                            n = bpName;
                        }
                    } else if (this.fluentSetters && rt.isParentOf((ClassInfo)ci)) {
                        methodType = MethodType.SETTER;
                    }
                } else if (params.size() == 2 && "*".equals(bpName) && ((ParameterInfo)params.get(0)).getParameterType().is(String.class)) {
                    methodType = n.startsWith("set") && (rt.isParentOf((ClassInfo)ci) || rt.is(Void.TYPE)) ? MethodType.SETTER : MethodType.GETTER;
                    n = bpName;
                }
                n = pn.getPropertyName(n);
                if ("*".equals(bpName) && methodType == MethodType.UNKNOWN) {
                    throw ThrowableUtils.bex((ClassInfo)ci, (String)"Found @Beanp(\"*\") but could not determine method type on method ''{0}''.", (Object[])new Object[]{m.getSimpleName()});
                }
                if (methodType == MethodType.UNKNOWN) continue;
                if (Utils.nn((Object)bpName) && !bpName.isEmpty()) {
                    n = bpName;
                }
                if (!Utils.nn((Object)n)) continue;
                l.add(new BeanMethod(n, methodType, m.inner()));
            }
        });
        return l;
    }

    private BeanRegistry findBeanRegistry() {
        ArrayList<ClassInfo> beanDictionaryClasses = Utils.opt((Object)this.beanFilter).map(x -> new ArrayList<ClassInfo>(x.getBeanDictionary())).orElse(new ArrayList());
        List ba = this.beanContext.getAnnotationProvider().find(Bean.class, this.classMeta, new AnnotationTraversal[0]);
        ba.stream().map(x -> ((Bean)x.inner()).typeName()).filter(Utils::ne).findFirst().ifPresent(x -> beanDictionaryClasses.add((ClassInfo)this.classMeta));
        return new BeanRegistry(this.beanContext, null, beanDictionaryClasses);
    }

    private List<ClassInfo> findClassHierarchy() {
        LinkedList result = new LinkedList();
        ClassInfo c2 = Utils.nn((Object)this.beanFilter) && Utils.nn((Object)this.beanFilter.getInterfaceClass()) ? this.beanFilter.getInterfaceClass() : this.classMeta;
        this.findClassHierarchy(c2, this.stopClass, result::add);
        return CollectionUtils.u(result);
    }

    private void findClassHierarchy(ClassInfo c, ClassInfo stopClass, Consumer<ClassInfo> consumer) {
        ClassInfo sc = c.getSuperclass();
        if (Utils.nn((Object)sc) && !sc.is(stopClass.inner())) {
            this.findClassHierarchy(sc, stopClass, consumer);
        }
        c.getInterfaces().forEach(x -> this.findClassHierarchy((ClassInfo)x, stopClass, consumer));
        consumer.accept(c);
    }

    private String findDictionaryName() {
        String s;
        if (Utils.nn((Object)this.beanFilter) && Utils.nn((Object)this.beanFilter.getTypeName())) {
            return this.beanFilter.getTypeName();
        }
        BeanRegistry br = this.getBeanRegistry();
        if (Utils.nn((Object)br) && Utils.nn((Object)(s = br.getTypeName(this.classMeta)))) {
            return s;
        }
        String n = this.classMeta.getParentsAndInterfaces().stream().skip(1L).map(x -> this.beanContext.getClassMeta((Type)x, new Type[0])).map(x -> x.getBeanRegistry()).filter(Objects::nonNull).map(x -> x.getTypeName(this.classMeta)).filter(Objects::nonNull).findFirst().orElse(null);
        if (n != null) {
            return n;
        }
        return this.classMeta.getBeanContext().getAnnotationProvider().find(Bean.class, this.classMeta, new AnnotationTraversal[0]).stream().map(AnnotationInfo::inner).filter(x -> !x.typeName().isEmpty()).map(x -> x.typeName()).findFirst().orElse(null);
    }

    private Optional<FieldInfo> findInnerBeanField(String name) {
        boolean noIgnoreTransients = !this.beanContext.isIgnoreTransientFields();
        AnnotationProvider ap = this.beanContext.getAnnotationProvider();
        return this.classHierarchy.get().stream().flatMap(c2 -> c2.getDeclaredField(x -> !(!x.isNotStatic() || !x.isNotTransient() && !noIgnoreTransients || x.hasAnnotation(Transient.class) && !noIgnoreTransients || ap.has(BeanIgnore.class, x, new AnnotationTraversal[0]) || !x.hasName(name))).stream()).findFirst();
    }

    record BeanMetaValue<T>(BeanMeta<T> beanMeta, String notABeanReason) {
        Optional<BeanMeta<T>> optBeanMeta() {
            return Utils.opt(this.beanMeta());
        }

        Optional<String> optNotABeanReason() {
            return Utils.opt((Object)this.notABeanReason());
        }
    }

    private record BeanConstructor(Optional<ConstructorInfo> constructor, List<String> args) {
    }

    static enum MethodType {
        UNKNOWN,
        GETTER,
        SETTER,
        EXTRAKEYS;

    }

    private static class BeanMethod {
        private String propertyName;
        private MethodType methodType;
        private Method method;
        private ClassInfo type;

        private BeanMethod(String propertyName, MethodType type, Method method) {
            this.propertyName = propertyName;
            this.methodType = type;
            this.method = method;
            this.type = ReflectionUtils.info(type == MethodType.SETTER ? method.getParameterTypes()[0] : method.getReturnType());
        }

        public String toString() {
            return this.method.toString();
        }

        private boolean matchesPropertyType(BeanPropertyMeta.Builder b) {
            if (b == null) {
                return false;
            }
            if ("*".equals(b.name)) {
                return true;
            }
            Class<?> pt = null;
            if (Utils.nn((Object)b.getter)) {
                pt = b.getter.getReturnType().inner();
            } else if (Utils.nn((Object)b.field)) {
                pt = b.field.inner().getType();
            }
            if (pt == null) {
                return true;
            }
            if (!this.type.isParentOf(pt)) {
                return false;
            }
            if (b.setter == null) {
                return true;
            }
            return this.type.isStrictChildOf(((ClassInfo)b.setter.getParameterTypes().get(0)).inner());
        }
    }
}

