/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.abandon;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.message.AbandonRequest;
import org.apache.directory.api.ldap.model.message.AbandonRequestImpl;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitAbandonRequest
extends GrammarAction<LdapMessageContainer<AbandonRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitAbandonRequest.class);

    public InitAbandonRequest() {
        super("Init Abandon Request");
    }

    public void action(LdapMessageContainer<AbandonRequest> container) throws DecoderException {
        AbandonRequestImpl abandonRequest = new AbandonRequestImpl();
        abandonRequest.setMessageId(container.getMessageId());
        container.setMessage((AbandonRequest)abandonRequest);
        TLV tlv = container.getCurrentTLV();
        BerValue value = tlv.getValue();
        if (value == null || value.getData() == null) {
            String msg = I18n.err((I18n)I18n.ERR_05109_ABANDON_REQ_MSG_ID_NULL, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        try {
            int abandonnedMessageId = IntegerDecoder.parse((BerValue)value, (int)0, (int)Integer.MAX_VALUE);
            abandonRequest.setAbandoned(abandonnedMessageId);
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_05110_ABANDON_MSG_ID_DECODED, (Object[])new Object[]{abandonnedMessageId}));
            }
            container.setGrammarEndAllowed(true);
        }
        catch (IntegerDecoderException ide) {
            LOG.error(I18n.err((I18n)I18n.ERR_05110_INVALID_ABANDON_REQ_MSG_ID, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData()), ide.getMessage()}));
            throw new DecoderException(ide.getMessage(), (Throwable)ide);
        }
    }
}

