/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.ArrayList;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;

public class Generator {
    public long start;
    public long end;
    public long step;
    public final String namePattern;
    public final int type;
    public final int dclass;
    public final long ttl;
    public final String rdataPattern;
    public final Name origin;
    private long current;

    public static boolean supportedType(int type) {
        Type.check(type);
        return type == 12 || type == 5 || type == 39 || type == 1 || type == 28 || type == 2;
    }

    public Generator(long start, long end, long step, String namePattern, int type, int dclass, long ttl, String rdataPattern, Name origin) {
        if (start < 0L || end < 0L || start > end || step <= 0L) {
            throw new IllegalArgumentException("invalid range specification");
        }
        if (!Generator.supportedType(type)) {
            throw new IllegalArgumentException("unsupported type");
        }
        DClass.check(dclass);
        this.start = start;
        this.end = end;
        this.step = step;
        this.namePattern = namePattern;
        this.type = type;
        this.dclass = dclass;
        this.ttl = ttl;
        this.rdataPattern = rdataPattern;
        this.origin = origin;
        this.current = start;
    }

    private String substitute(String spec, long n) throws IOException {
        boolean escaped = false;
        byte[] str = spec.getBytes();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length; ++i) {
            char c = (char)(str[i] & 0xFF);
            if (escaped) {
                sb.append(c);
                escaped = false;
                continue;
            }
            if (c == '\\') {
                if (i + 1 == str.length) {
                    throw new TextParseException("invalid escape character");
                }
                escaped = true;
                continue;
            }
            if (c == '$') {
                long v;
                boolean negative = false;
                long offset = 0L;
                long width = 0L;
                long base = 10L;
                boolean wantUpperCase = false;
                if (i + 1 < str.length && str[i + 1] == 36) {
                    c = (char)(str[++i] & 0xFF);
                    sb.append(c);
                    continue;
                }
                if (i + 1 < str.length && str[i + 1] == 123) {
                    if (++i + 1 < str.length && str[i + 1] == 45) {
                        negative = true;
                        ++i;
                    }
                    while (i + 1 < str.length && (c = (char)(str[++i] & 0xFF)) != ',' && c != '}') {
                        if (c < '0' || c > '9') {
                            throw new TextParseException("invalid offset");
                        }
                        c = (char)(c - 48);
                        offset *= 10L;
                        offset += (long)c;
                    }
                    if (negative) {
                        offset = -offset;
                    }
                    if (c == ',') {
                        while (i + 1 < str.length && (c = (char)(str[++i] & 0xFF)) != ',' && c != '}') {
                            if (c < '0' || c > '9') {
                                throw new TextParseException("invalid width");
                            }
                            c = (char)(c - 48);
                            width *= 10L;
                            width += (long)c;
                        }
                    }
                    if (c == ',') {
                        if (i + 1 == str.length) {
                            throw new TextParseException("invalid base");
                        }
                        if ((c = (char)(str[++i] & 0xFF)) == 'o') {
                            base = 8L;
                        } else if (c == 'x') {
                            base = 16L;
                        } else if (c == 'X') {
                            base = 16L;
                            wantUpperCase = true;
                        } else if (c != 'd') {
                            throw new TextParseException("invalid base");
                        }
                    }
                    if (i + 1 == str.length || str[i + 1] != 125) {
                        throw new TextParseException("invalid modifiers");
                    }
                    ++i;
                }
                if ((v = n + offset) < 0L) {
                    throw new TextParseException("invalid offset expansion");
                }
                String number = base == 8L ? Long.toOctalString(v) : (base == 16L ? Long.toHexString(v) : Long.toString(v));
                if (wantUpperCase) {
                    number = number.toUpperCase();
                }
                if (width != 0L && width > (long)number.length()) {
                    int zeros = (int)width - number.length();
                    while (zeros-- > 0) {
                        sb.append('0');
                    }
                }
                sb.append(number);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public Record nextRecord() throws IOException {
        if (this.current > this.end) {
            return null;
        }
        String namestr = this.substitute(this.namePattern, this.current);
        Name name = Name.fromString(namestr, this.origin);
        String rdata = this.substitute(this.rdataPattern, this.current);
        this.current += this.step;
        return Record.fromString(name, this.type, this.dclass, this.ttl, rdata, this.origin);
    }

    public Record[] expand() throws IOException {
        ArrayList<Record> list = new ArrayList<Record>();
        for (long i = this.start; i < this.end; i += this.step) {
            String namestr = this.substitute(this.namePattern, this.current);
            Name name = Name.fromString(namestr, this.origin);
            String rdata = this.substitute(this.rdataPattern, this.current);
            list.add(Record.fromString(name, this.type, this.dclass, this.ttl, rdata, this.origin));
        }
        return list.toArray(new Record[0]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("$GENERATE ");
        sb.append(this.start).append("-").append(this.end);
        if (this.step > 1L) {
            sb.append("/").append(this.step);
        }
        sb.append(" ");
        sb.append(this.namePattern).append(" ");
        sb.append(this.ttl).append(" ");
        if (this.dclass != 1 || !Options.check("noPrintIN")) {
            sb.append(DClass.string(this.dclass)).append(" ");
        }
        sb.append(Type.string(this.type)).append(" ");
        sb.append(this.rdataPattern).append(" ");
        return sb.toString();
    }
}

