/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import org.openide.util.NbBundle;

/**
 *
 * @author jpeska
 */
public class SortPanel extends javax.swing.JPanel {

    private final TaskSorter sorter = TaskSorter.getInstance();
    private final Set<SortAttributePanel> panels = new HashSet<SortAttributePanel>(NUMBER_OF_COMBOS);
    private static final int NUMBER_OF_COMBOS = 4;
    private List<TaskAttribute> attributes;
    private final SortingChangeListener listener;

    /**
     * Creates new form SortPanel
     */
    public SortPanel() {
        listener = new SortingChangeListener();
        initComponents();
        initCombos();
        pnlAttributes.add(new JLabel(), new GridBagConstraints(0, NUMBER_OF_COMBOS, 1, 1, 0.0, 1.0, GridBagConstraints.WEST, GridBagConstraints.VERTICAL, new Insets(0, 0, 3, 0), 0, 0));
    }

    public void saveAttributes() {
        sorter.setAttributes(attributes);
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        pnlAttributes = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();

        pnlAttributes.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, NbBundle.getMessage(SortPanel.class, "SortPanel.jLabel1.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 3, 10);
        pnlAttributes.add(jLabel1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, NbBundle.getMessage(SortPanel.class, "SortPanel.jLabel2.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 3, 10);
        pnlAttributes.add(jLabel2, gridBagConstraints);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(pnlAttributes, javax.swing.GroupLayout.DEFAULT_SIZE, 600, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(pnlAttributes, javax.swing.GroupLayout.DEFAULT_SIZE, 127, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel pnlAttributes;
    // End of variables declaration//GEN-END:variables

    private void initCombos() {
        attributes = new ArrayList<TaskAttribute>(sorter.getAttributes());
        boolean previousHasRank = true;
        for (int i = 0; i < NUMBER_OF_COMBOS; i++) {
            TaskAttribute att = attributes.get(i);
            boolean hasRank = att.getRank() != TaskAttribute.NO_RANK;
            SortAttributePanel panel = new SortAttributePanel(attributes, hasRank ? att : null, i + 1);
            if (!previousHasRank) {
                panel.setEnabled(false);
            }
            previousHasRank = hasRank;
            panel.addSortingChangeListener(listener);
            pnlAttributes.add(panel, new GridBagConstraints(1, i, 1, 1, 1.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 3, 0), 0, 0));
            panels.add(panel);
        }
    }

    private class SortingChangeListener implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            Collections.sort(attributes);
            boolean previousHasRank = true;
            for (SortAttributePanel panel : panels) {
                panel.removeSortingChangeListener(listener);

                TaskAttribute selectCandidate = attributes.get(panel.getIndex() - 1);
                previousHasRank = selectCandidate.getRank() != TaskAttribute.NO_RANK;
                panel.updateModel(previousHasRank ? selectCandidate : null);

                if (panel.getIndex() > 1) {
                    TaskAttribute previousAttr = attributes.get(panel.getIndex() - 2);
                    panel.setComponentsEnabled(previousAttr.getRank() != TaskAttribute.NO_RANK);
                }

                panel.addSortingChangeListener(listener);
            }
        }

    }
}
