/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.csv;

import java.io.IOException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;

public final class CSVFormat {
    private static final char COMMA = ',';
    private static final char COMMENT = '#';
    private static final char CR = '\r';
    private static final String CRLF = "\r\n";
    private static final Character DOUBLE_QUOTE_CHAR = Character.valueOf('\"');
    private static final String EMPTY = "";
    private static final char LF = '\n';
    private static final char SP = ' ';
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final char _delimiter;
    private final Character _quoteCharacter;
    private final String _recordSeparator;

    public CSVFormat() {
        this(',', DOUBLE_QUOTE_CHAR, CRLF);
    }

    private CSVFormat(char delimiter, Character quoteCharacter, String recordSeparator) {
        if (delimiter == '\n' || delimiter == '\r') {
            throw new IllegalArgumentException("The _delimiter cannot be a line break");
        }
        if (quoteCharacter != null && delimiter == quoteCharacter.charValue()) {
            throw new IllegalArgumentException("The quote character and the delimiter cannot be the same ('" + quoteCharacter + "')");
        }
        this._delimiter = delimiter;
        this._quoteCharacter = quoteCharacter;
        this._recordSeparator = recordSeparator;
    }

    public <T extends Collection<?>> void printRecord(Appendable out, T record) throws IOException {
        boolean newRecord = true;
        for (Object item : record) {
            this.print(out, item, newRecord);
            newRecord = false;
        }
        this.println(out);
    }

    public <C extends Collection<? extends Collection<?>>> void printRecords(Appendable out, C records) throws IOException {
        for (Collection<?> record : records) {
            this.printRecord(out, record);
        }
    }

    public void println(Appendable out) throws IOException {
        if (this._recordSeparator != null) {
            out.append(this._recordSeparator);
        }
    }

    public void print(Appendable out, Object value, boolean newRecord) throws IOException {
        CharSequence charSequence;
        if (value == null) {
            charSequence = EMPTY;
        } else if (value instanceof CharSequence) {
            charSequence = (CharSequence)value;
        } else if (value instanceof Date || value instanceof Calendar) {
            Date time = value instanceof Calendar ? ((Calendar)value).getTime() : (Date)value;
            charSequence = DATE_TIME_FORMATTER.format(time.toInstant().atZone(ZoneId.systemDefault()));
        } else {
            charSequence = value.toString();
        }
        this.print(out, value, charSequence, 0, charSequence.length(), newRecord);
    }

    public void printComments(Appendable out, String ... comments) throws IOException {
        for (String comment : comments) {
            out.append('#').append(' ').append(comment);
            this.println(out);
        }
    }

    private void print(Appendable out, Object object, CharSequence value, int offset, int len, boolean newRecord) throws IOException {
        if (!newRecord) {
            out.append(this._delimiter);
        }
        if (object == null) {
            out.append(value);
        } else if (this._quoteCharacter != null) {
            this.printAndQuote(value, offset, len, out, newRecord);
        } else {
            out.append(value, offset, offset + len);
        }
    }

    private void printAndQuote(CharSequence value, int offset, int len, Appendable out, boolean newRecord) throws IOException {
        char c;
        int pos;
        boolean quote = false;
        int start = offset;
        int end = offset + len;
        char quoteChar = this._quoteCharacter.charValue();
        if (len <= 0) {
            if (newRecord) {
                quote = true;
            }
        } else {
            c = value.charAt(pos);
            if (c <= '#') {
                quote = true;
            } else {
                for (pos = offset; pos < end; ++pos) {
                    c = value.charAt(pos);
                    if (c != '\n' && c != '\r' && c != quoteChar && c != this._delimiter) continue;
                    quote = true;
                    break;
                }
                if (!quote && (c = value.charAt(pos = end - 1)) <= ' ') {
                    quote = true;
                }
            }
        }
        if (!quote) {
            out.append(value, start, end);
            return;
        }
        out.append(quoteChar);
        while (pos < end) {
            c = value.charAt(pos);
            if (c == quoteChar) {
                out.append(value, start, pos + 1);
                start = pos;
            }
            ++pos;
        }
        out.append(value, start, pos);
        out.append(quoteChar);
    }
}

