/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util.xml.serialize;

import com.ctc.wstx.stax.WstxOutputFactory;
import com.sun.xml.txw2.output.IndentingXMLStreamWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.jackrabbit.vault.util.xml.serialize.OutputFormat;

public class FormattingXmlStreamWriter
implements XMLStreamWriter,
AutoCloseable {
    private final Writer rawWriter;
    private final XMLStreamWriter writer;
    private final OutputFormat output;
    private final IndentingXMLStreamWriter elementIndentingXmlWriter;
    int numNamespaceDeclarations = 0;
    int numAttributes = 0;
    private int depth = 0;
    private Attribute bufferedAttribute;

    public static FormattingXmlStreamWriter create(OutputStream output, OutputFormat format) throws XMLStreamException, FactoryConfigurationError {
        WstxOutputFactory factory = new WstxOutputFactory();
        ((XMLOutputFactory)factory).setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", true);
        return new FormattingXmlStreamWriter(factory, output, format);
    }

    private FormattingXmlStreamWriter(XMLOutputFactory factory, OutputStream output, OutputFormat format) throws XMLStreamException, FactoryConfigurationError {
        this(factory.createXMLStreamWriter(output, StandardCharsets.UTF_8.name()), format);
    }

    private FormattingXmlStreamWriter(XMLStreamWriter writer, OutputFormat output) {
        this.output = output;
        this.writer = writer;
        this.rawWriter = (Writer)writer.getProperty("com.ctc.wstx.outputUnderlyingWriter");
        if (this.rawWriter == null) {
            throw new IllegalStateException("Could not get underlying writer!");
        }
        this.elementIndentingXmlWriter = new IndentingXMLStreamWriter(writer);
        this.elementIndentingXmlWriter.setIndentStep(output.getIndent());
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.elementIndentingXmlWriter.writeEndDocument();
        this.addLineBreak(true);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.onStartElement();
        this.elementIndentingXmlWriter.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.onStartElement();
        this.elementIndentingXmlWriter.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.onStartElement();
        this.elementIndentingXmlWriter.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.flushBufferedAttribute();
        --this.depth;
        this.elementIndentingXmlWriter.writeEndElement();
    }

    private void onStartElement() throws XMLStreamException {
        this.flushBufferedAttribute();
        this.numNamespaceDeclarations = 0;
        this.numAttributes = 0;
        ++this.depth;
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        ++this.numNamespaceDeclarations;
        this.elementIndentingXmlWriter.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (this.onAttribute(null, null, localName, value)) {
            this.elementIndentingXmlWriter.writeAttribute(localName, value);
        }
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (this.onAttribute(prefix, namespaceURI, localName, value)) {
            this.elementIndentingXmlWriter.writeAttribute(prefix, namespaceURI, localName, value);
        }
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        if (this.onAttribute(null, namespaceURI, localName, value)) {
            this.elementIndentingXmlWriter.writeAttribute(namespaceURI, localName, value);
        }
    }

    private boolean onAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        ++this.numAttributes;
        if (this.output.isSplitAttributesByLineBreaks()) {
            if (this.numNamespaceDeclarations + this.numAttributes > 1) {
                if (this.bufferedAttribute != null) {
                    this.addLineBreak(true);
                    this.indent(true);
                    this.flushBufferedAttribute();
                }
                this.addLineBreak(true);
                this.indent(true);
            } else {
                this.bufferedAttribute = new Attribute(prefix, namespaceURI, localName, value);
                return false;
            }
        }
        return true;
    }

    private boolean flushBufferedAttribute() throws XMLStreamException {
        if (this.bufferedAttribute != null) {
            this.bufferedAttribute.write(this.writer);
            this.bufferedAttribute = null;
            return true;
        }
        return false;
    }

    private void indent(boolean isAttribute) throws XMLStreamException {
        try {
            this.writer.flush();
            if (this.depth > 0) {
                for (int i = 0; i < this.depth; ++i) {
                    String indent = isAttribute && i == this.depth - 1 ? this.output.getIndent().substring(0, this.output.getIndent().length() - 1) : this.output.getIndent();
                    this.rawWriter.write(indent);
                }
            }
            this.rawWriter.flush();
        }
        catch (IOException e) {
            throw new XMLStreamException("Could not indent attribute", e);
        }
    }

    private void addLineBreak(boolean keepState) throws XMLStreamException {
        if (keepState) {
            try {
                this.writer.flush();
                this.rawWriter.write(10);
                this.rawWriter.flush();
            }
            catch (IOException e) {
                throw new XMLStreamException("Could not add line break", e);
            }
        } else {
            this.writeCharacters("\n");
        }
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.flushBufferedAttribute();
        this.addLineBreak(false);
        this.indent(false);
        this.elementIndentingXmlWriter.writeComment(data);
    }

    @Override
    public void close() throws XMLStreamException {
        this.elementIndentingXmlWriter.close();
    }

    public void setIndentStep(String s) {
        this.elementIndentingXmlWriter.setIndentStep(s);
    }

    @Override
    public void flush() throws XMLStreamException {
        this.elementIndentingXmlWriter.flush();
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.elementIndentingXmlWriter.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.elementIndentingXmlWriter.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.elementIndentingXmlWriter.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.elementIndentingXmlWriter.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.elementIndentingXmlWriter.writeStartDocument(version);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.elementIndentingXmlWriter.writeDTD(dtd);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.elementIndentingXmlWriter.writeStartDocument(encoding, version);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.elementIndentingXmlWriter.writeEntityRef(name);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.elementIndentingXmlWriter.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.elementIndentingXmlWriter.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.elementIndentingXmlWriter.setPrefix(prefix, uri);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.elementIndentingXmlWriter.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.elementIndentingXmlWriter.setDefaultNamespace(uri);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.elementIndentingXmlWriter.writeEmptyElement(localName);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.elementIndentingXmlWriter.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.elementIndentingXmlWriter.getNamespaceContext();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.elementIndentingXmlWriter.getProperty(name);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.elementIndentingXmlWriter.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.elementIndentingXmlWriter.writeCharacters(text, start, len);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.elementIndentingXmlWriter.writeCData(data);
    }

    public String toString() {
        return this.elementIndentingXmlWriter.toString();
    }

    private final class Attribute {
        private final String prefix;
        private final String namespaceURI;
        private final String localName;
        private final String value;

        public Attribute(String prefix, String namespaceURI, String localName, String value) {
            this.prefix = prefix;
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.value = value;
        }

        public void write(XMLStreamWriter writer) throws XMLStreamException {
            if (this.prefix == null) {
                if (this.namespaceURI == null) {
                    writer.writeAttribute(this.localName, this.value);
                } else {
                    writer.writeAttribute(this.namespaceURI, this.localName, this.value);
                }
            } else {
                writer.writeAttribute(this.prefix, this.namespaceURI, this.localName, this.value);
            }
        }
    }
}

