/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.spi.base;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.spi.ClusterSyncService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSyncServiceChain
implements ClusterSyncService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<ClusterSyncService> chain;
    private AtomicLong syncCnt = new AtomicLong(0L);

    public ClusterSyncServiceChain(ClusterSyncService ... chain) {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("chain must be 1 or more");
        }
        this.chain = Arrays.asList(chain);
    }

    @Override
    public void sync(BaseTopologyView view, Runnable callback) {
        if (view == null) {
            throw new NullPointerException("view must not be null");
        }
        if (callback == null) {
            throw new NullPointerException("callback must not be null");
        }
        Iterator<ClusterSyncService> chainIt = this.chain.iterator();
        this.chainedSync(view, callback, chainIt, this.syncCnt.getAndIncrement());
    }

    private void chainedSync(final BaseTopologyView view, final Runnable callback, final Iterator<ClusterSyncService> chainIt, final long executionCnt) {
        if (!chainIt.hasNext()) {
            this.logger.debug("doSync: done with sync chain, invoking callback");
            callback.run();
            return;
        }
        ClusterSyncService next = chainIt.next();
        next.sync(view, new Runnable(){

            @Override
            public void run() {
                if (ClusterSyncServiceChain.this.canExecute(executionCnt)) {
                    ClusterSyncServiceChain.this.chainedSync(view, callback, chainIt, executionCnt);
                }
            }
        });
        this.canExecute(executionCnt);
    }

    private boolean canExecute(long executionCnt) {
        long currentCnt = this.syncCnt.get();
        if (currentCnt > executionCnt + 1L) {
            this.logger.info("canExecute : cancelling old, outdated sync ({} > {} + 1) (currentCnt > executionCnt + 1)", (Object)currentCnt, (Object)executionCnt);
            this.cancelSync();
            return false;
        }
        return true;
    }

    @Override
    public void cancelSync() {
        this.syncCnt.incrementAndGet();
        for (ClusterSyncService consistencyService : this.chain) {
            consistencyService.cancelSync();
        }
    }
}

