/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.cm.json.io.Configurations;
import org.apache.sling.feature.extension.apiregions.api.config.DescribableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.Mode;
import org.apache.sling.feature.extension.apiregions.api.config.PropertyDescription;
import org.apache.sling.feature.extension.apiregions.api.config.Region;

public abstract class ConfigurableEntity
extends DescribableEntity {
    private final Map<String, PropertyDescription> properties = Configurations.newConfiguration();
    private Mode mode;
    private boolean allowAdditional;
    private Region region;
    private final List<String> internalProperties = new ArrayList<String>();

    @Override
    protected void setDefaults() {
        super.setDefaults();
        this.setAllowAdditionalProperties(false);
        this.setRegion(Region.GLOBAL);
    }

    @Override
    public void clear() {
        super.clear();
        this.properties.clear();
        this.setMode(null);
        this.getInternalPropertyNames().clear();
    }

    @Override
    public void fromJSONObject(JsonObject jsonObj) throws IOException {
        super.fromJSONObject(jsonObj);
        try {
            String regionVal;
            String modeVal;
            JsonValue val = this.getAttributes().remove("properties");
            if (val != null) {
                for (Map.Entry innerEntry : val.asJsonObject().entrySet()) {
                    PropertyDescription prop = new PropertyDescription();
                    prop.fromJSONObject(((JsonValue)innerEntry.getValue()).asJsonObject());
                    if (this.getPropertyDescriptions().put((String)innerEntry.getKey(), prop) == null) continue;
                    throw new IOException("Duplicate key for property description (keys are case-insensitive) : ".concat((String)innerEntry.getKey()));
                }
            }
            if ((modeVal = this.getString("mode")) != null) {
                this.setMode(Mode.valueOf(modeVal.toUpperCase()));
            }
            if ((regionVal = this.getString("region")) != null) {
                this.setRegion(Region.valueOf(regionVal.toUpperCase()));
            }
            this.setAllowAdditionalProperties(this.getBoolean("allow-additional-properties", this.isAllowAdditionalProperties()));
            val = this.getAttributes().remove("internal-property-names");
            if (val != null) {
                for (JsonValue v : val.asJsonArray()) {
                    this.getInternalPropertyNames().add(this.getString(v));
                }
            }
        }
        catch (JsonException | IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public Map<String, PropertyDescription> getPropertyDescriptions() {
        return this.properties;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode value) {
        this.mode = value;
    }

    public boolean isAllowAdditionalProperties() {
        return this.allowAdditional;
    }

    public void setAllowAdditionalProperties(boolean flag) {
        this.allowAdditional = flag;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region == null ? Region.GLOBAL : region;
    }

    public List<String> getInternalPropertyNames() {
        return this.internalProperties;
    }

    @Override
    protected JsonObjectBuilder createJson() throws IOException {
        JsonObjectBuilder objBuilder = super.createJson();
        if (!this.getPropertyDescriptions().isEmpty()) {
            JsonObjectBuilder propBuilder = Json.createObjectBuilder();
            for (Map.Entry<String, PropertyDescription> entry : this.getPropertyDescriptions().entrySet()) {
                propBuilder.add(entry.getKey(), entry.getValue().createJson());
            }
            objBuilder.add("properties", propBuilder);
        }
        if (this.getMode() != null) {
            objBuilder.add("mode", this.getMode().name());
        }
        if (this.getRegion() != Region.GLOBAL) {
            objBuilder.add("region", this.getRegion().name());
        }
        if (this.isAllowAdditionalProperties()) {
            objBuilder.add("allow-additional-properties", this.isAllowAdditionalProperties());
        }
        if (!this.getInternalPropertyNames().isEmpty()) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (String name : this.getInternalPropertyNames()) {
                arrayBuilder.add(name);
            }
            objBuilder.add("internal-property-names", arrayBuilder);
        }
        return objBuilder;
    }
}

