/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.cursor;

import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.apache.jackrabbit.oak.plugins.index.cursor.PathCursor;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.jetbrains.annotations.Nullable;

class AncestorCursor
extends PathCursor {
    public AncestorCursor(Cursor cursor, int level, QueryLimits settings) {
        super(AncestorCursor.transform(cursor, level), true, settings);
    }

    private static Iterator<String> transform(Cursor cursor, final int level) {
        Iterator<String> unfiltered = IteratorUtils.transform(cursor, input -> input != null ? input.getPath() : null);
        Iterator<String> filtered = IteratorUtils.filter(unfiltered, (new Predicate<String>(){

            @Override
            public boolean test(@Nullable String input) {
                return input != null && PathUtils.getDepth(input) >= level;
            }
        })::test);
        return IteratorUtils.transform(filtered, input -> PathUtils.getAncestorPath(input, level));
    }
}

