/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache;

import java.util.Locale;
import java.util.Objects;

public final class Expirable<V> {
    private final V value;
    private volatile long expireTimeMS;

    public Expirable(V value, long expireTimeMS) {
        this.value = Objects.requireNonNull(value);
        this.expireTimeMS = expireTimeMS;
    }

    public V get() {
        return this.value;
    }

    public long getExpireTimeMS() {
        return this.expireTimeMS;
    }

    public void setExpireTimeMS(long expireTimeMS) {
        this.expireTimeMS = expireTimeMS;
    }

    public boolean hasExpired(long currentTimeMS) {
        return currentTimeMS - this.expireTimeMS >= 0L;
    }

    public boolean isEternal() {
        return this.expireTimeMS == Long.MAX_VALUE;
    }

    public String toString() {
        return String.format(Locale.US, "%s{value=%s, expireTimeMS=%,d}", this.getClass().getSimpleName(), this.value, this.expireTimeMS);
    }
}

