/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.RelationshipTypeTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.provisioning.api.data.RelationshipTypeDataBinder;
import org.apache.syncope.core.provisioning.api.event.EntityLifecycleEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class RelationshipTypeLogic
extends AbstractTransactionalLogic<RelationshipTypeTO> {
    protected final RelationshipTypeDataBinder binder;
    protected final RelationshipTypeDAO relationshipTypeDAO;
    protected final ApplicationEventPublisher publisher;

    public RelationshipTypeLogic(RelationshipTypeDataBinder binder, RelationshipTypeDAO relationshipTypeDAO, ApplicationEventPublisher publisher) {
        this.binder = binder;
        this.relationshipTypeDAO = relationshipTypeDAO;
        this.publisher = publisher;
    }

    @PreAuthorize(value="hasRole('RELATIONSHIPTYPE_READ')")
    @Transactional(readOnly=true)
    public RelationshipTypeTO read(String key) {
        RelationshipType relationshipType = (RelationshipType)this.relationshipTypeDAO.findById(key).orElseThrow(() -> new NotFoundException("RelationshipType " + key));
        return this.binder.getRelationshipTypeTO(relationshipType);
    }

    @PreAuthorize(value="hasRole('RELATIONSHIPTYPE_LIST')")
    @Transactional(readOnly=true)
    public List<RelationshipTypeTO> list() {
        return this.relationshipTypeDAO.findAll().stream().map(arg_0 -> ((RelationshipTypeDataBinder)this.binder).getRelationshipTypeTO(arg_0)).toList();
    }

    @PreAuthorize(value="hasRole('RELATIONSHIPTYPE_CREATE')")
    public RelationshipTypeTO create(RelationshipTypeTO relationshipTypeTO) {
        RelationshipType relationshipType = (RelationshipType)this.relationshipTypeDAO.save((Entity)this.binder.create(relationshipTypeTO));
        this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.CREATE, (Entity)relationshipType, AuthContextUtils.getDomain()));
        return this.binder.getRelationshipTypeTO(relationshipType);
    }

    @PreAuthorize(value="hasRole('RELATIONSHIPTYPE_UPDATE')")
    public RelationshipTypeTO update(RelationshipTypeTO relationshipTypeTO) {
        RelationshipType relationshipType = (RelationshipType)this.relationshipTypeDAO.findById(relationshipTypeTO.getKey()).orElseThrow(() -> new NotFoundException("RelationshipType " + relationshipTypeTO.getKey()));
        this.binder.update(relationshipType, relationshipTypeTO);
        relationshipType = (RelationshipType)this.relationshipTypeDAO.save((Entity)relationshipType);
        this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)relationshipType, AuthContextUtils.getDomain()));
        return this.binder.getRelationshipTypeTO(relationshipType);
    }

    @PreAuthorize(value="hasRole('RELATIONSHIPTYPE_DELETE')")
    public RelationshipTypeTO delete(String key) {
        RelationshipType relationshipType = (RelationshipType)this.relationshipTypeDAO.findById(key).orElseThrow(() -> new NotFoundException("RelationshipType " + key));
        RelationshipTypeTO deleted = this.binder.getRelationshipTypeTO(relationshipType);
        this.relationshipTypeDAO.deleteById(key);
        this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.DELETE, (Entity)relationshipType, AuthContextUtils.getDomain()));
        return deleted;
    }

    @Override
    protected RelationshipTypeTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof Long) {
                    key = (String)args[i];
                    continue;
                }
                Object object = args[i];
                if (!(object instanceof RelationshipTypeTO)) continue;
                RelationshipTypeTO relationshipTypeTO = (RelationshipTypeTO)object;
                key = relationshipTypeTO.getKey();
            }
        }
        if (StringUtils.isNotBlank(key)) {
            try {
                return this.binder.getRelationshipTypeTO((RelationshipType)this.relationshipTypeDAO.findById(key).orElseThrow());
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

