/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler.advice;

import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.advice.AbstractRequestHandlerAdvice;
import org.springframework.integration.handler.advice.RetryStateGenerator;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryState;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class RequestHandlerRetryAdvice
extends AbstractRequestHandlerAdvice {
    private static final IntegrationRetryListener INTEGRATION_RETRY_LISTENER = new IntegrationRetryListener();
    private RetryTemplate retryTemplate = new RetryTemplate();
    private RecoveryCallback<Object> recoveryCallback;
    private RetryStateGenerator retryStateGenerator = message -> null;

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        Assert.notNull((Object)retryTemplate, (String)"'retryTemplate' cannot be null");
        this.retryTemplate = retryTemplate;
    }

    public void setRecoveryCallback(RecoveryCallback<Object> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    public void setRetryStateGenerator(RetryStateGenerator retryStateGenerator) {
        Assert.notNull((Object)retryStateGenerator, (String)"'retryStateGenerator' cannot be null");
        this.retryStateGenerator = retryStateGenerator;
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.retryTemplate.registerListener((RetryListener)INTEGRATION_RETRY_LISTENER);
    }

    @Override
    protected Object doInvoke(AbstractRequestHandlerAdvice.ExecutionCallback callback, Object target, Message<?> message) {
        IntegrationRetryCallback retryCallback = new IntegrationRetryCallback(message, callback, target);
        RetryState retryState = this.retryStateGenerator.determineRetryState(message);
        try {
            return this.retryTemplate.execute((RetryCallback)retryCallback, this.recoveryCallback, retryState);
        }
        catch (MessagingException ex) {
            if (ex.getFailedMessage() == null) {
                throw new MessagingException(message, "Failed to invoke handler", (Throwable)ex);
            }
            throw ex;
        }
        catch (AbstractRequestHandlerAdvice.ThrowableHolderException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AbstractRequestHandlerAdvice.ThrowableHolderException(ex);
        }
    }

    private static class IntegrationRetryListener
    implements RetryListener {
        IntegrationRetryListener() {
        }

        public <T, E extends Throwable> boolean open(RetryContext context, RetryCallback<T, E> callback) {
            Assert.state((boolean)(callback instanceof IntegrationRetryCallback), (String)"A 'RequestHandlerRetryAdvice' cannot be used as a 'RetryListener'");
            context.setAttribute("message", ((IntegrationRetryCallback)callback).messageToTry);
            return true;
        }
    }

    private record IntegrationRetryCallback(Message<?> messageToTry, AbstractRequestHandlerAdvice.ExecutionCallback callback, Object target) implements RetryCallback<Object, Exception>
    {
        public Object doWithRetry(RetryContext context) {
            return this.callback.cloneAndExecute();
        }

        public String getLabel() {
            String string;
            Object object = this.target;
            if (object instanceof AbstractReplyProducingMessageHandler.RequestHandler) {
                AbstractReplyProducingMessageHandler.RequestHandler requestHandler = (AbstractReplyProducingMessageHandler.RequestHandler)object;
                string = requestHandler.getAdvisedHandler().getComponentName();
            } else {
                string = this.target.getClass().getName();
            }
            return string;
        }
    }
}

