/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.parsing;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.parsing.PropertyParser;
import org.apache.ibatis.parsing.XNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XPathParser {
    private final Document document;
    private boolean validation;
    private EntityResolver entityResolver;
    private Properties variables;
    private XPath xpath;

    public XPathParser(String xml) {
        this.commonConstructor(false, null, null);
        this.document = this.createDocument(new InputSource(new StringReader(xml)));
    }

    public XPathParser(Reader reader) {
        this.commonConstructor(false, null, null);
        this.document = this.createDocument(new InputSource(reader));
    }

    public XPathParser(InputStream inputStream) {
        this.commonConstructor(false, null, null);
        this.document = this.createDocument(new InputSource(inputStream));
    }

    public XPathParser(Document document) {
        this.commonConstructor(false, null, null);
        this.document = document;
    }

    public XPathParser(String xml, boolean validation) {
        this.commonConstructor(validation, null, null);
        this.document = this.createDocument(new InputSource(new StringReader(xml)));
    }

    public XPathParser(Reader reader, boolean validation) {
        this.commonConstructor(validation, null, null);
        this.document = this.createDocument(new InputSource(reader));
    }

    public XPathParser(InputStream inputStream, boolean validation) {
        this.commonConstructor(validation, null, null);
        this.document = this.createDocument(new InputSource(inputStream));
    }

    public XPathParser(Document document, boolean validation) {
        this.commonConstructor(validation, null, null);
        this.document = document;
    }

    public XPathParser(String xml, boolean validation, Properties variables) {
        this.commonConstructor(validation, variables, null);
        this.document = this.createDocument(new InputSource(new StringReader(xml)));
    }

    public XPathParser(Reader reader, boolean validation, Properties variables) {
        this.commonConstructor(validation, variables, null);
        this.document = this.createDocument(new InputSource(reader));
    }

    public XPathParser(InputStream inputStream, boolean validation, Properties variables) {
        this.commonConstructor(validation, variables, null);
        this.document = this.createDocument(new InputSource(inputStream));
    }

    public XPathParser(Document document, boolean validation, Properties variables) {
        this.commonConstructor(validation, variables, null);
        this.document = document;
    }

    public XPathParser(String xml, boolean validation, Properties variables, EntityResolver entityResolver) {
        this.commonConstructor(validation, variables, entityResolver);
        this.document = this.createDocument(new InputSource(new StringReader(xml)));
    }

    public XPathParser(Reader reader, boolean validation, Properties variables, EntityResolver entityResolver) {
        this.commonConstructor(validation, variables, entityResolver);
        this.document = this.createDocument(new InputSource(reader));
    }

    public XPathParser(InputStream inputStream, boolean validation, Properties variables, EntityResolver entityResolver) {
        this.commonConstructor(validation, variables, entityResolver);
        this.document = this.createDocument(new InputSource(inputStream));
    }

    public XPathParser(Document document, boolean validation, Properties variables, EntityResolver entityResolver) {
        this.commonConstructor(validation, variables, entityResolver);
        this.document = document;
    }

    public void setVariables(Properties variables) {
        this.variables = variables;
    }

    public String evalString(String expression) {
        return this.evalString(this.document, expression);
    }

    public String evalString(Object root, String expression) {
        String result = (String)this.evaluate(expression, root, XPathConstants.STRING);
        return PropertyParser.parse(result, this.variables);
    }

    public Boolean evalBoolean(String expression) {
        return this.evalBoolean(this.document, expression);
    }

    public Boolean evalBoolean(Object root, String expression) {
        return (Boolean)this.evaluate(expression, root, XPathConstants.BOOLEAN);
    }

    public Short evalShort(String expression) {
        return this.evalShort(this.document, expression);
    }

    public Short evalShort(Object root, String expression) {
        return Short.valueOf(this.evalString(root, expression));
    }

    public Integer evalInteger(String expression) {
        return this.evalInteger(this.document, expression);
    }

    public Integer evalInteger(Object root, String expression) {
        return Integer.valueOf(this.evalString(root, expression));
    }

    public Long evalLong(String expression) {
        return this.evalLong(this.document, expression);
    }

    public Long evalLong(Object root, String expression) {
        return Long.valueOf(this.evalString(root, expression));
    }

    public Float evalFloat(String expression) {
        return this.evalFloat(this.document, expression);
    }

    public Float evalFloat(Object root, String expression) {
        return Float.valueOf(this.evalString(root, expression));
    }

    public Double evalDouble(String expression) {
        return this.evalDouble(this.document, expression);
    }

    public Double evalDouble(Object root, String expression) {
        return (Double)this.evaluate(expression, root, XPathConstants.NUMBER);
    }

    public List<XNode> evalNodes(String expression) {
        return this.evalNodes(this.document, expression);
    }

    public List<XNode> evalNodes(Object root, String expression) {
        ArrayList<XNode> xnodes = new ArrayList<XNode>();
        NodeList nodes = (NodeList)this.evaluate(expression, root, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            xnodes.add(new XNode(this, nodes.item(i), this.variables));
        }
        return xnodes;
    }

    public XNode evalNode(String expression) {
        return this.evalNode(this.document, expression);
    }

    public XNode evalNode(Object root, String expression) {
        Node node = (Node)this.evaluate(expression, root, XPathConstants.NODE);
        if (node == null) {
            return null;
        }
        return new XNode(this, node, this.variables);
    }

    private Object evaluate(String expression, Object root, QName returnType) {
        try {
            return this.xpath.evaluate(expression, root, returnType);
        }
        catch (Exception e) {
            throw new BuilderException("Error evaluating XPath.  Cause: " + e, e);
        }
    }

    private Document createDocument(InputSource inputSource) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setValidating(this.validation);
            factory.setNamespaceAware(false);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(false);
            factory.setCoalescing(false);
            factory.setExpandEntityReferences(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(this.entityResolver);
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                }
            });
            return builder.parse(inputSource);
        }
        catch (Exception e) {
            throw new BuilderException("Error creating document instance.  Cause: " + e, e);
        }
    }

    private void commonConstructor(boolean validation, Properties variables, EntityResolver entityResolver) {
        this.validation = validation;
        this.entityResolver = entityResolver;
        this.variables = variables;
        XPathFactory factory = XPathFactory.newInstance();
        this.xpath = factory.newXPath();
    }
}

