/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks;

import com.github.benmanes.caffeine.cache.Expiry;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.jwks.OidcJsonWebKeystoreProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.jose4j.jwk.JsonWebKeySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcServiceJsonWebKeystoreCacheExpirationPolicy
implements Expiry<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcServiceJsonWebKeystoreCacheExpirationPolicy.class);
    private final CasConfigurationProperties casProperties;

    public long expireAfterCreate(OidcJsonWebKeyCacheKey service, Optional<JsonWebKeySet> jsonWebKey, long currentTime) {
        return this.getExpiration(service);
    }

    public long expireAfterUpdate(OidcJsonWebKeyCacheKey service, Optional<JsonWebKeySet> jsonWebKey, long currentTime, long currentDuration) {
        return this.getExpiration(service);
    }

    public long expireAfterRead(OidcJsonWebKeyCacheKey service, Optional<JsonWebKeySet> jsonWebKey, long currentTime, long currentDuration) {
        return this.getExpiration(service);
    }

    private long getExpiration(OidcJsonWebKeyCacheKey givenService) {
        LOGGER.trace("Attempting to determine JWKS cache expiration value for [{}]", (Object)givenService);
        OAuthRegisteredService oAuthRegisteredService = givenService.getRegisteredService();
        if (oAuthRegisteredService instanceof OidcRegisteredService) {
            OidcRegisteredService service = (OidcRegisteredService)oAuthRegisteredService;
            if (StringUtils.isNotBlank((CharSequence)service.getJwksCacheDuration())) {
                long expiration = Beans.newDuration((String)service.getJwksCacheDuration()).toNanos();
                LOGGER.trace("JWKS cache expiration value for service [{}] is set to [{}]", (Object)service, (Object)expiration);
                return expiration;
            }
            OidcJsonWebKeystoreProperties jwks = this.casProperties.getAuthn().getOidc().getJwks();
            long expiration = Beans.newDuration((String)jwks.getCore().getJwksCacheExpiration()).toNanos();
            LOGGER.trace("CAS JWKS cache expiration value is set to [{}]", (Object)expiration);
            return expiration;
        }
        return -1L;
    }

    @Generated
    public OidcServiceJsonWebKeystoreCacheExpirationPolicy(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }
}

