/*
 * Decompiled with CFR 0.152.
 */
package kafka.test.junit;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.test.ClusterConfig;
import kafka.test.annotation.AutoStart;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTemplate;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.util.ReflectionUtils;

public class ClusterTestExtensions
implements TestTemplateInvocationContextProvider {
    public boolean supportsTestTemplate(ExtensionContext context) {
        return true;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        ClusterTests clusterTestsAnnot;
        ClusterTest clusterTestAnnot;
        ClusterTestDefaults defaults = this.getClusterTestDefaults(context.getRequiredTestClass());
        ArrayList<TestTemplateInvocationContext> generatedContexts = new ArrayList<TestTemplateInvocationContext>();
        ClusterTemplate clusterTemplateAnnot = context.getRequiredTestMethod().getDeclaredAnnotation(ClusterTemplate.class);
        if (clusterTemplateAnnot != null) {
            generatedContexts.addAll(this.processClusterTemplate(context, clusterTemplateAnnot));
        }
        if ((clusterTestAnnot = context.getRequiredTestMethod().getDeclaredAnnotation(ClusterTest.class)) != null) {
            generatedContexts.addAll(this.processClusterTest(context, clusterTestAnnot, defaults));
        }
        if ((clusterTestsAnnot = context.getRequiredTestMethod().getDeclaredAnnotation(ClusterTests.class)) != null) {
            generatedContexts.addAll(this.processClusterTests(context, clusterTestsAnnot, defaults));
        }
        if (generatedContexts.isEmpty()) {
            throw new IllegalStateException("Please annotate test methods with @ClusterTemplate, @ClusterTest, or @ClusterTests when using the ClusterTestExtensions provider");
        }
        return generatedContexts.stream();
    }

    List<TestTemplateInvocationContext> processClusterTemplate(ExtensionContext context, ClusterTemplate annot) {
        if (annot.value().trim().isEmpty()) {
            throw new IllegalStateException("ClusterTemplate value can't be empty string.");
        }
        String baseDisplayName = context.getRequiredTestMethod().getName();
        List<TestTemplateInvocationContext> contexts = this.generateClusterConfigurations(context, annot.value()).stream().flatMap(config -> config.clusterTypes().stream().map(type -> type.invocationContexts(baseDisplayName, (ClusterConfig)config))).collect(Collectors.toList());
        if (contexts.isEmpty()) {
            throw new IllegalStateException("ClusterConfig generator method should provide at least one config");
        }
        return contexts;
    }

    private List<ClusterConfig> generateClusterConfigurations(ExtensionContext context, String generateClustersMethods) {
        Object testInstance = context.getTestInstance().orElse(null);
        Method method = ReflectionUtils.getRequiredMethod((Class)context.getRequiredTestClass(), (String)generateClustersMethods, (Class[])new Class[0]);
        return (List)ReflectionUtils.invokeMethod((Method)method, testInstance, (Object[])new Object[0]);
    }

    private List<TestTemplateInvocationContext> processClusterTests(ExtensionContext context, ClusterTests annots, ClusterTestDefaults defaults) {
        List<TestTemplateInvocationContext> ret = Arrays.stream(annots.value()).flatMap(annot -> this.processClusterTestInternal(context, (ClusterTest)annot, defaults).stream()).collect(Collectors.toList());
        if (ret.isEmpty()) {
            throw new IllegalStateException("processClusterTests method should provide at least one config");
        }
        return ret;
    }

    private List<TestTemplateInvocationContext> processClusterTest(ExtensionContext context, ClusterTest annot, ClusterTestDefaults defaults) {
        List<TestTemplateInvocationContext> ret = this.processClusterTestInternal(context, annot, defaults);
        if (ret.isEmpty()) {
            throw new IllegalStateException("processClusterTest method should provide at least one config");
        }
        return ret;
    }

    private List<TestTemplateInvocationContext> processClusterTestInternal(ExtensionContext context, ClusterTest annot, ClusterTestDefaults defaults) {
        Type[] types = annot.types().length == 0 ? defaults.types() : annot.types();
        Map<String, String> serverProperties = Stream.concat(Arrays.stream(defaults.serverProperties()), Arrays.stream(annot.serverProperties())).filter(e -> e.id() == -1).collect(Collectors.toMap(ClusterConfigProperty::key, ClusterConfigProperty::value, (a, b) -> b));
        Map<Integer, Map<String, String>> perServerProperties = Stream.concat(Arrays.stream(defaults.serverProperties()), Arrays.stream(annot.serverProperties())).filter(e -> e.id() != -1).collect(Collectors.groupingBy(ClusterConfigProperty::id, Collectors.mapping(Function.identity(), Collectors.toMap(ClusterConfigProperty::key, ClusterConfigProperty::value, (a, b) -> b))));
        ClusterConfig config = ClusterConfig.builder().setTypes(new HashSet<Type>(Arrays.asList(types))).setBrokers(annot.brokers() == 0 ? defaults.brokers() : annot.brokers()).setControllers(annot.controllers() == 0 ? defaults.controllers() : annot.controllers()).setDisksPerBroker(annot.disksPerBroker() == 0 ? defaults.disksPerBroker() : annot.disksPerBroker()).setAutoStart(annot.autoStart() == AutoStart.DEFAULT ? defaults.autoStart() : annot.autoStart() == AutoStart.YES).setListenerName(annot.listener().trim().isEmpty() ? null : annot.listener()).setServerProperties(serverProperties).setPerServerProperties(perServerProperties).setSecurityProtocol(annot.securityProtocol()).setMetadataVersion(annot.metadataVersion()).setTags(Arrays.asList(annot.tags())).build();
        return Arrays.stream(types).map(type -> type.invocationContexts(context.getRequiredTestMethod().getName(), config)).collect(Collectors.toList());
    }

    private ClusterTestDefaults getClusterTestDefaults(Class<?> testClass) {
        return Optional.ofNullable(testClass.getDeclaredAnnotation(ClusterTestDefaults.class)).orElseGet(() -> EmptyClass.class.getDeclaredAnnotation(ClusterTestDefaults.class));
    }

    @ClusterTestDefaults
    private static final class EmptyClass {
        private EmptyClass() {
        }
    }
}

