/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.scripting;

import java.io.File;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.springframework.core.io.Resource;

public interface ExecutableCompiledScriptFactory {
    public static final String SYSTEM_PROPERTY_GROOVY_COMPILE_STATIC = "org.apereo.cas.groovy.compile.static";

    public ExecutableCompiledScript fromResource(Resource var1, boolean var2);

    default public ExecutableCompiledScript fromResource(Resource resource) {
        return this.fromResource(resource, true);
    }

    public ExecutableCompiledScript fromScript(String var1);

    public String createTemplate(String var1, Map<String, ?> var2) throws Exception;

    public String createTemplate(File var1, Map<String, ?> var2) throws Exception;

    public <T> T newObjectInstance(String var1, Class<T> var2) throws Exception;

    public <T> T newObjectInstance(Resource var1, Class[] var2, Object[] var3, Class<T> var4);

    public static Optional<ExecutableCompiledScriptFactory> findExecutableCompiledScriptFactory() {
        return ServiceLoader.load(ExecutableCompiledScriptFactory.class).stream().map(ServiceLoader.Provider::get).findFirst();
    }

    public static ExecutableCompiledScriptFactory getExecutableCompiledScriptFactory() {
        return ExecutableCompiledScriptFactory.findExecutableCompiledScriptFactory().orElseThrow(() -> new IllegalArgumentException("No executable compiled script factory is found. Your CAS server is not configured to support scripting. Examine your build and make sure you have included the CAS dependency/module that provides the script factory implementation."));
    }

    default public boolean isInlineScript(String input) {
        return this.getInlineScript(input).isPresent();
    }

    default public boolean isExternalScript(String input) {
        return this.getExternalScript(input).isPresent();
    }

    default public boolean isScript(String text) {
        return this.isExternalScript(text) || this.isInlineScript(text);
    }

    public Optional<String> getInlineScript(String var1);

    public Optional<String> getExternalScript(String var1);

    public URLClassLoader newClassLoader();
}

