/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.syncope;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apereo.cas.acct.AccountRegistrationRequest;
import org.apereo.cas.acct.AccountRegistrationResponse;
import org.apereo.cas.acct.provision.AccountRegistrationProvisioner;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.configuration.model.support.syncope.SyncopeAccountManagementRegistrationProvisioningProperties;
import org.apereo.cas.syncope.SyncopeUtils;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class SyncopeAccountRegistrationProvisioner
implements AccountRegistrationProvisioner {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncopeAccountRegistrationProvisioner.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final SyncopeAccountManagementRegistrationProvisioningProperties properties;

    public AccountRegistrationResponse provision(AccountRegistrationRequest request) {
        AccountRegistrationResponse response = new AccountRegistrationResponse();
        Splitter.on((String)",").splitToList((CharSequence)this.properties.getDomain()).stream().map(Unchecked.function(domain -> this.submitRequest(request, (String)domain))).forEach(result -> {
            response.putProperty((String)result.getProperty("domain", String.class), result);
            response.putProperty("success", (Object)result.isSuccess());
        });
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccountRegistrationResponse submitRequest(AccountRegistrationRequest request, String domain) throws Exception {
        HttpResponse response;
        block2: {
            AccountRegistrationResponse accountRegistrationResponse;
            response = null;
            try {
                String syncopeRestUrl = StringUtils.appendIfMissing((String)SpringExpressionLanguageValueResolver.getInstance().resolve(this.properties.getUrl()), (CharSequence)"/rest/users", (CharSequence[])new CharSequence[0]);
                Map headers = CollectionUtils.wrap((String)"X-Syncope-Domain", (Object)domain, (String)"Accept", (Object)"application/json", (String)"Content-Type", (Object)"application/json");
                headers.putAll(this.properties.getHeaders());
                String entity = MAPPER.writeValueAsString(SyncopeUtils.convertToUserCreateEntity(request.getProperties(), new UsernamePasswordCredential(request.getUsername(), request.getPassword()), this.getSyncopeRealm(request)));
                HttpExecutionRequest exec = HttpExecutionRequest.builder().method(HttpMethod.POST).url(syncopeRestUrl).basicAuthUsername(this.properties.getBasicAuthUsername()).basicAuthPassword(this.properties.getBasicAuthPassword()).headers(headers).entity(entity).build();
                response = Objects.requireNonNull(HttpUtils.execute((HttpExecutionRequest)exec));
                LOGGER.debug("Received http response status as [{}]", (Object)response.getReasonPhrase());
                if (HttpStatus.valueOf((int)response.getCode()).isError()) break block2;
                String result = EntityUtils.toString((HttpEntity)((HttpEntityContainer)response).getEntity());
                LOGGER.debug("Received user object as [{}]", (Object)result);
                Map responseJson = (Map)MAPPER.readValue(result, (TypeReference)new TypeReference<Map<String, Object>>(this){});
                accountRegistrationResponse = AccountRegistrationResponse.success().putProperty("domain", (Object)domain).putProperty("entity", responseJson.get("entity")).putProperty("propagationStatuses", responseJson.get("propagationStatuses"));
            }
            catch (Throwable throwable) {
                HttpUtils.close(response);
                throw throwable;
            }
            HttpUtils.close((HttpResponse)response);
            return accountRegistrationResponse;
        }
        HttpUtils.close((HttpResponse)response);
        return AccountRegistrationResponse.failure().putProperty("domain", (Object)domain);
    }

    protected String getSyncopeRealm(AccountRegistrationRequest request) {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)request.getProperty("realm", String.class)), (CharSequence)this.properties.getRealm());
    }

    @Generated
    public SyncopeAccountRegistrationProvisioner(SyncopeAccountManagementRegistrationProvisioningProperties properties) {
        this.properties = properties;
    }
}

