/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JoinGroupRequestTest {
    @Test
    public void shouldAcceptValidGroupInstanceIds() {
        String[] validGroupInstanceIds;
        String maxLengthString = TestUtils.randomString(249);
        for (String instanceId : validGroupInstanceIds = new String[]{"valid", "INSTANCE", "gRoUp", "ar6", "VaL1d", "_0-9_.", "...", maxLengthString}) {
            JoinGroupRequest.validateGroupInstanceId((String)instanceId);
        }
    }

    @Test
    public void shouldThrowOnInvalidGroupInstanceIds() {
        String[] invalidGroupInstanceIds;
        char[] longString = new char[250];
        Arrays.fill(longString, 'a');
        for (String instanceId : invalidGroupInstanceIds = new String[]{"", "foo bar", "..", "foo:bar", "foo=bar", ".", new String(longString)}) {
            try {
                JoinGroupRequest.validateGroupInstanceId((String)instanceId);
                Assertions.fail((String)("No exception was thrown for invalid instance id: " + instanceId));
            }
            catch (InvalidConfigurationException invalidConfigurationException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testRequestVersionCompatibilityFailBuild() {
        Assertions.assertThrows(UnsupportedVersionException.class, () -> new JoinGroupRequest.Builder(new JoinGroupRequestData().setGroupId("groupId").setMemberId("consumerId").setGroupInstanceId("groupInstanceId").setProtocolType("consumer")).build((short)4));
    }

    @Test
    public void testRebalanceTimeoutDefaultsToSessionTimeoutV0() {
        int sessionTimeoutMs = 30000;
        short version = 0;
        ByteBuffer buffer = MessageUtil.toByteBuffer((Message)new JoinGroupRequestData().setGroupId("groupId").setMemberId("consumerId").setProtocolType("consumer").setSessionTimeoutMs(sessionTimeoutMs), (short)version);
        JoinGroupRequest request = JoinGroupRequest.parse((ByteBuffer)buffer, (short)version);
        Assertions.assertEquals((int)sessionTimeoutMs, (int)request.data().sessionTimeoutMs());
        Assertions.assertEquals((int)sessionTimeoutMs, (int)request.data().rebalanceTimeoutMs());
    }
}

