/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.widget.treeview;

import org.apache.wicket.Page;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.io.IClusterable;

public class TreeNode<T>
implements IClusterable {
    private static final long serialVersionUID = 1L;
    public static final int ROOT = 0;
    private static int sequence = 1;
    private final int uid;
    private final int pid;
    private final T wrapped;
    private CharSequence url = null;

    public TreeNode(int id, T object) {
        this(id, 0, object);
    }

    public TreeNode(int id, T object, CharSequence url) {
        this(id, 0, object, url);
    }

    public TreeNode(int id, T object, Class<? extends Page> pageClass) {
        this(id, 0, object, pageClass, new PageParameters());
    }

    public TreeNode(int id, T object, Class<? extends Page> pageClass, PageParameters parameters) {
        this(id, 0, object, RequestCycle.get().urlFor(pageClass, parameters));
    }

    public TreeNode(int id, int parentId, T object) {
        this.uid = id;
        this.pid = parentId;
        this.wrapped = object;
    }

    public TreeNode(int id, int parentId, T object, CharSequence url) {
        this(id, parentId, object);
        this.url = url;
    }

    public TreeNode(int id, int parentId, T object, Class<? extends Page> pageClass) {
        this(id, parentId, object, pageClass, new PageParameters());
    }

    public TreeNode(int id, int parentId, T object, Class<? extends Page> pageClass, PageParameters parameters) {
        this(id, parentId, object, RequestCycle.get().urlFor(pageClass, parameters));
    }

    public int getId() {
        return this.uid;
    }

    public int getParentId() {
        return this.pid;
    }

    public String getText() {
        return String.valueOf(this.wrapped);
    }

    public T getObject() {
        return this.wrapped;
    }

    public CharSequence getUrl() {
        return this.url;
    }

    public boolean hasChildren() {
        return true;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public static synchronized int nextSequence() {
        return sequence++ % Integer.MAX_VALUE;
    }

    public static <T> TreeNode<T> of(T object) {
        return new TreeNode<T>(TreeNode.nextSequence(), object);
    }

    public static <T> TreeNode<T> of(int parentId, T object) {
        return new TreeNode<T>(TreeNode.nextSequence(), parentId, object);
    }
}

