/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.http.openid.model;

import jakarta.json.Json;
import jakarta.json.JsonReader;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.security.enterprise.identitystore.openid.AccessToken;
import jakarta.security.enterprise.identitystore.openid.JwtClaims;
import jakarta.security.enterprise.identitystore.openid.Scope;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Base64;
import java.util.Map;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.security.http.openid.model.TomEEJwtClaims;

public class TomEEAccesToken
implements AccessToken,
Serializable {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.TOMEE_SECURITY, TomEEAccesToken.class);
    private final boolean jwt;
    private final String token;
    private final AccessToken.Type type;
    private final Scope scope;
    private final Long expiresIn;
    private final long minValidity;
    private final long creationTime;
    private JwtClaims jwtClaims;
    private Map<String, Object> rawClaims;

    public TomEEAccesToken(boolean jwt, String token, AccessToken.Type type, Scope scope, Long expiresIn, long minValidity) {
        this.jwt = jwt;
        this.token = token;
        this.type = type;
        this.scope = scope;
        this.expiresIn = expiresIn;
        this.minValidity = minValidity;
        this.creationTime = System.currentTimeMillis() / 1000L;
        if (jwt) {
            String json = new String(Base64.getUrlDecoder().decode(token.split("\\.")[1]));
            try (JsonReader reader = Json.createReader((Reader)new StringReader(json));
                 Jsonb jsonb = JsonbBuilder.create();){
                this.jwtClaims = new TomEEJwtClaims(reader.readObject());
                this.rawClaims = (Map)jsonb.fromJson(json, Map.class);
            }
            catch (Exception e) {
                LOGGER.error("Could not parse idToken claims", (Throwable)e);
            }
        }
    }

    public String getToken() {
        return this.token;
    }

    public boolean isJWT() {
        return this.jwt;
    }

    public JwtClaims getJwtClaims() {
        return this.jwtClaims;
    }

    public Map<String, Object> getClaims() {
        return this.rawClaims;
    }

    public Object getClaim(String key) {
        if (!this.isJWT()) {
            return null;
        }
        return this.getClaims().get(key);
    }

    public Long getExpirationTime() {
        return this.expiresIn;
    }

    public boolean isExpired() {
        long expirationTimeSeconds = !this.isJWT() ? this.creationTime + this.expiresIn : this.jwtClaims.getExpirationTime().map(it -> it.toEpochMilli() / 1000L).orElseThrow(() -> new IllegalStateException("No exp claim in identity token found"));
        return System.currentTimeMillis() + this.minValidity > expirationTimeSeconds * 1000L;
    }

    public Scope getScope() {
        return this.scope;
    }

    public AccessToken.Type getType() {
        return this.type;
    }
}

