/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.error.Error;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.TextFileReader;
import org.hsqldb.persist.TextFileReader8;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowInputText;

public class TextFileReader16
extends TextFileReader8
implements TextFileReader {
    TextFileReader16(RandomAccessInterface randomAccessInterface, TextFileSettings textFileSettings, RowInputInterface rowInputInterface, boolean bl) {
        this.dataFile = randomAccessInterface;
        this.textFileSettings = textFileSettings;
        this.rowIn = rowInputInterface;
        this.buffer = TextFileReader8.StringCreator.getStringCreator(Character.TYPE, textFileSettings.charEncoding);
        this.skipBOM();
    }

    private void skipBOM() {
        try {
            if (this.textFileSettings.isUTF16) {
                this.dataFile.seek(0L);
                if (this.dataFile.read() == 254 && this.dataFile.read() == 255) {
                    this.position = 2L;
                } else {
                    this.dataFile.seek(0L);
                    if (this.dataFile.read() == 255 && this.dataFile.read() == 254) {
                        this.position = 2L;
                        this.textFileSettings.setLittleEndianByteOrderMark();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    @Override
    int getByteSizeForChar() {
        return 2;
    }

    @Override
    int readChar() {
        try {
            int n = this.dataFile.read();
            if (n == -1) {
                return -1;
            }
            int n2 = this.dataFile.read();
            if (n2 == -1) {
                return -1;
            }
            if (this.textFileSettings.isLittleEndian) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            return (char)((n << 8) + n2);
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    @Override
    public String getHeaderLine() {
        return this.header;
    }

    @Override
    public long getLineNumber() {
        return ((RowInputText)this.rowIn).getLineNumber();
    }
}

