/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.core;

import org.apache.uima.cas.CAS;
import org.apache.uima.ruta.textruler.core.TextRulerAnnotation;
import org.apache.uima.ruta.textruler.core.TextRulerExampleDocument;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;

public class TextRulerExample {
    protected TextRulerExampleDocument document;
    protected TextRulerAnnotation[] annotations;
    protected boolean isPositive;
    protected TextRulerTarget target;

    public TextRulerExample(TextRulerExampleDocument document, TextRulerAnnotation annotation, boolean isPositive, TextRulerTarget target) {
        TextRulerAnnotation[] singleAnnot = new TextRulerAnnotation[]{annotation};
        this.document = document;
        this.isPositive = isPositive;
        this.target = target;
        this.annotations = singleAnnot;
    }

    public TextRulerExample(TextRulerExampleDocument document, TextRulerAnnotation[] annotations, boolean isPositive, TextRulerTarget target) {
        this.document = document;
        this.isPositive = isPositive;
        this.target = target;
        this.annotations = annotations;
    }

    public TextRulerExampleDocument getDocument() {
        return this.document;
    }

    public CAS getDocumentCAS() {
        return this.document.getCAS();
    }

    public TextRulerAnnotation getAnnotation() {
        return this.annotations[0];
    }

    public TextRulerAnnotation[] getAnnotations() {
        return this.annotations;
    }

    public boolean isPositive() {
        return this.isPositive;
    }

    public void setPositive(boolean flag) {
        this.isPositive = flag;
    }

    public TextRulerTarget getTarget() {
        return this.target;
    }

    public String toString() {
        if (this.target.type != TextRulerTarget.MLTargetType.MULTI_SLOT) {
            if (this.annotations != null) {
                if (this.target.type == TextRulerTarget.MLTargetType.SINGLE_WHOLE_SLOT) {
                    return this.getAnnotation().getCoveredText();
                }
                return "START at " + this.getAnnotation().getBegin();
            }
            return "<no text>";
        }
        Object str = "";
        for (TextRulerAnnotation a : this.annotations) {
            str = a == null ? (String)str + "<NULL>" : (String)str + a.getType().getShortName() + ":" + a.getCoveredText() + ";";
        }
        return str;
    }

    public boolean equals(Object ob) {
        boolean result;
        TextRulerExample o = (TextRulerExample)ob;
        boolean bl = result = this.document.getCasFileName().equals(o.document.getCasFileName()) && this.isPositive == o.isPositive && this.target.equals(o.target);
        if (!result) {
            return false;
        }
        if (this.annotations.length != o.annotations.length) {
            return false;
        }
        for (int i = 0; i < this.annotations.length; ++i) {
            if (this.annotations[i].equals(o.annotations[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.document.getCasFileName().hashCode() * (this.isPositive ? 2 : 1) * (this.target.type == TextRulerTarget.MLTargetType.MULTI_SLOT ? 1 : (this.target.type == TextRulerTarget.MLTargetType.SINGLE_WHOLE_SLOT ? 2 : (this.target.type == TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY ? 3 : 4)));
        int i = 1;
        for (TextRulerAnnotation a : this.annotations) {
            result *= i * (a.getBegin() + 1) * (a.getEnd() + 1);
            ++i;
        }
        return result;
    }
}

