/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.insd.edit.vars;

import java.util.Arrays;
import java.util.List;
import org.apache.uima.pear.insd.edit.vars.IVarValListViewer;
import org.apache.uima.pear.insd.edit.vars.VarVal;
import org.apache.uima.pear.insd.edit.vars.VarValList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

abstract class AbstractVarValViewerHandler {
    public Table table;
    public TableViewer tableViewer;
    public Button add;
    public Button delete;
    protected Button closeButton;
    protected ITableLabelProvider labelProvider;
    protected VarValList tableRowList = new VarValList();
    protected String[] columnNames;

    public AbstractVarValViewerHandler(Composite parent, String[] columnNames, int numParentColumns, VarValList tableRowList, ITableLabelProvider labelProvider) {
        this.tableRowList = tableRowList;
        this.columnNames = columnNames;
        this.labelProvider = labelProvider;
        this.addChildControls(parent, numParentColumns);
    }

    protected abstract void createTableColumns();

    protected abstract CellEditor[] createCellEditors();

    protected abstract ICellModifier createCellModifiers();

    protected abstract ViewerSorter createSorter();

    public void dispose() {
        this.tableViewer.getLabelProvider().dispose();
    }

    protected void addChildControls(Composite composite, int numColumns) {
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginWidth = 4;
        composite.setLayout((Layout)layout);
        this.createTable(composite);
        this.createTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new ExampleContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tableViewer.setInput((Object)this.tableRowList);
        this.createButtons(composite);
    }

    protected void createTable(Composite parent) {
        int style = 101124;
        this.table = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        gridData.heightHint = 60;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.createTableColumns();
    }

    protected void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(this.columnNames);
        this.tableViewer.setCellEditors(this.createCellEditors());
        this.tableViewer.setCellModifier(this.createCellModifiers());
        this.tableViewer.setSorter(this.createSorter());
    }

    public void close() {
        Shell shell = this.table.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.dispose();
        }
    }

    protected void createButtons(Composite parent) {
        this.add = new Button(parent, 0x1000008);
        this.add.setText("Add");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        this.add.setLayoutData((Object)gridData);
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AbstractVarValViewerHandler.this.tableRowList.addTableRow()) {
                    MessageDialog.openWarning((Shell)new Shell(), (String)"Duplicate Variable", (String)"The variable 'New_Variable' already exists");
                }
            }
        });
        this.delete = new Button(parent, 0x1000008);
        this.delete.setText("Delete");
        gridData = new GridData(32);
        gridData.widthHint = 80;
        this.delete.setLayoutData((Object)gridData);
        this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VarVal tableRow = (VarVal)((IStructuredSelection)AbstractVarValViewerHandler.this.tableViewer.getSelection()).getFirstElement();
                if (tableRow != null) {
                    AbstractVarValViewerHandler.this.tableRowList.removeTableRow(tableRow);
                }
            }
        });
    }

    public List getColumnNames() {
        return Arrays.asList(this.columnNames);
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public VarValList getTableRowList() {
        return this.tableRowList;
    }

    public Control getControl() {
        return this.table.getParent();
    }

    public Button getCloseButton() {
        return this.closeButton;
    }

    class ExampleContentProvider
    implements IStructuredContentProvider,
    IVarValListViewer {
        ExampleContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((VarValList)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((VarValList)oldInput).removeChangeListener(this);
            }
        }

        public void dispose() {
            AbstractVarValViewerHandler.this.tableRowList.removeChangeListener(this);
        }

        public Object[] getElements(Object parent) {
            return AbstractVarValViewerHandler.this.tableRowList.getTableRows().toArray();
        }

        @Override
        public void addTableRow(VarVal tableRow) {
            AbstractVarValViewerHandler.this.tableViewer.add((Object)tableRow);
        }

        @Override
        public void removeTableRow(VarVal tableRow) {
            AbstractVarValViewerHandler.this.tableViewer.remove((Object)tableRow);
        }

        @Override
        public void updateTableRow(VarVal tableRow) {
            AbstractVarValViewerHandler.this.tableViewer.update((Object)tableRow, null);
        }
    }
}

